// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionInner;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in PolicySetDefinitionsClient.
 */
public interface PolicySetDefinitionsClient {
    /**
     * Creates or updates a policy set definition.
     * 
     * This operation creates or updates a policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionInner>> createOrUpdateWithResponseAsync(String policySetDefinitionName,
        PolicySetDefinitionInner parameters);

    /**
     * Creates or updates a policy set definition.
     * 
     * This operation creates or updates a policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionInner> createOrUpdateAsync(String policySetDefinitionName,
        PolicySetDefinitionInner parameters);

    /**
     * Creates or updates a policy set definition.
     * 
     * This operation creates or updates a policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionInner> createOrUpdateWithResponse(String policySetDefinitionName,
        PolicySetDefinitionInner parameters, Context context);

    /**
     * Creates or updates a policy set definition.
     * 
     * This operation creates or updates a policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionInner createOrUpdate(String policySetDefinitionName, PolicySetDefinitionInner parameters);

    /**
     * Deletes a policy set definition.
     * 
     * This operation deletes the policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName);

    /**
     * Deletes a policy set definition.
     * 
     * This operation deletes the policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String policySetDefinitionName);

    /**
     * Deletes a policy set definition.
     * 
     * This operation deletes the policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String policySetDefinitionName, Context context);

    /**
     * Deletes a policy set definition.
     * 
     * This operation deletes the policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String policySetDefinitionName);

    /**
     * Retrieves a policy set definition.
     * 
     * This operation retrieves the policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionInner>> getWithResponseAsync(String policySetDefinitionName);

    /**
     * Retrieves a policy set definition.
     * 
     * This operation retrieves the policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionInner> getAsync(String policySetDefinitionName);

    /**
     * Retrieves a policy set definition.
     * 
     * This operation retrieves the policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionInner> getWithResponse(String policySetDefinitionName, Context context);

    /**
     * Retrieves a policy set definition.
     * 
     * This operation retrieves the policy set definition in the given subscription with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionInner get(String policySetDefinitionName);

    /**
     * Retrieves a built in policy set definition.
     * 
     * This operation retrieves the built-in policy set definition with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionInner>> getBuiltInWithResponseAsync(String policySetDefinitionName);

    /**
     * Retrieves a built in policy set definition.
     * 
     * This operation retrieves the built-in policy set definition with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionInner> getBuiltInAsync(String policySetDefinitionName);

    /**
     * Retrieves a built in policy set definition.
     * 
     * This operation retrieves the built-in policy set definition with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionInner> getBuiltInWithResponse(String policySetDefinitionName, Context context);

    /**
     * Retrieves a built in policy set definition.
     * 
     * This operation retrieves the built-in policy set definition with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionInner getBuiltIn(String policySetDefinitionName);

    /**
     * Retrieves the policy set definitions for a subscription.
     * 
     * This operation retrieves a list of all the policy set definitions in a given subscription that match the optional
     * given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     * 
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     * -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     * $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the given
     * scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     * definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     * Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionInner> listAsync(String filter, Integer top);

    /**
     * Retrieves the policy set definitions for a subscription.
     * 
     * This operation retrieves a list of all the policy set definitions in a given subscription that match the optional
     * given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionInner> listAsync();

    /**
     * Retrieves the policy set definitions for a subscription.
     * 
     * This operation retrieves a list of all the policy set definitions in a given subscription that match the optional
     * given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionInner> list();

    /**
     * Retrieves the policy set definitions for a subscription.
     * 
     * This operation retrieves a list of all the policy set definitions in a given subscription that match the optional
     * given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the subscription, including those that apply directly or from management groups that contain the given
     * subscription. If $filter=atExactScope() is provided, the returned list only includes all policy set definitions
     * that at the given subscription. If $filter='policyType -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn and
     * Custom. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     * 
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     * -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     * $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the given
     * scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     * definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     * Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionInner> list(String filter, Integer top, Context context);

    /**
     * Retrieves built-in policy set definitions.
     * 
     * This operation retrieves a list of all the built-in policy set definitions that match the optional given $filter.
     * If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     * 
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     * -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     * $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the given
     * scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     * definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     * Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionInner> listBuiltInAsync(String filter, Integer top);

    /**
     * Retrieves built-in policy set definitions.
     * 
     * This operation retrieves a list of all the built-in policy set definitions that match the optional given $filter.
     * If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionInner> listBuiltInAsync();

    /**
     * Retrieves built-in policy set definitions.
     * 
     * This operation retrieves a list of all the built-in policy set definitions that match the optional given $filter.
     * If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionInner> listBuiltIn();

    /**
     * Retrieves built-in policy set definitions.
     * 
     * This operation retrieves a list of all the built-in policy set definitions that match the optional given $filter.
     * If $filter='category -eq {value}' is provided, the returned list only includes all built-in policy set
     * definitions whose category match the {value}.
     * 
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     * -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     * $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the given
     * scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     * definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     * Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionInner> listBuiltIn(String filter, Integer top, Context context);

    /**
     * Creates or updates a policy set definition.
     * 
     * This operation creates or updates a policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters);

    /**
     * Creates or updates a policy set definition.
     * 
     * This operation creates or updates a policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionInner> createOrUpdateAtManagementGroupAsync(String policySetDefinitionName,
        String managementGroupId, PolicySetDefinitionInner parameters);

    /**
     * Creates or updates a policy set definition.
     * 
     * This operation creates or updates a policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionInner> createOrUpdateAtManagementGroupWithResponse(String policySetDefinitionName,
        String managementGroupId, PolicySetDefinitionInner parameters, Context context);

    /**
     * Creates or updates a policy set definition.
     * 
     * This operation creates or updates a policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionInner createOrUpdateAtManagementGroup(String policySetDefinitionName, String managementGroupId,
        PolicySetDefinitionInner parameters);

    /**
     * Deletes a policy set definition.
     * 
     * This operation deletes the policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String policySetDefinitionName,
        String managementGroupId);

    /**
     * Deletes a policy set definition.
     * 
     * This operation deletes the policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId);

    /**
     * Deletes a policy set definition.
     * 
     * This operation deletes the policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteAtManagementGroupWithResponse(String policySetDefinitionName, String managementGroupId,
        Context context);

    /**
     * Deletes a policy set definition.
     * 
     * This operation deletes the policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtManagementGroup(String policySetDefinitionName, String managementGroupId);

    /**
     * Retrieves a policy set definition.
     * 
     * This operation retrieves the policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionInner>> getAtManagementGroupWithResponseAsync(String policySetDefinitionName,
        String managementGroupId);

    /**
     * Retrieves a policy set definition.
     * 
     * This operation retrieves the policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionInner> getAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId);

    /**
     * Retrieves a policy set definition.
     * 
     * This operation retrieves the policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionInner> getAtManagementGroupWithResponse(String policySetDefinitionName,
        String managementGroupId, Context context);

    /**
     * Retrieves a policy set definition.
     * 
     * This operation retrieves the policy set definition in the given management group with the given name.
     * 
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionInner getAtManagementGroup(String policySetDefinitionName, String managementGroupId);

    /**
     * Retrieves all policy set definitions in management group.
     * 
     * This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     * 
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     * -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     * $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the given
     * scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     * definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     * Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(String managementGroupId, String filter,
        Integer top);

    /**
     * Retrieves all policy set definitions in management group.
     * 
     * This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     * 
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(String managementGroupId);

    /**
     * Retrieves all policy set definitions in management group.
     * 
     * This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     * 
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionInner> listByManagementGroup(String managementGroupId);

    /**
     * Retrieves all policy set definitions in management group.
     * 
     * This operation retrieves a list of all the policy set definitions in a given management group that match the
     * optional given $filter. Valid values for $filter are: 'atExactScope()', 'policyType -eq {value}' or 'category eq
     * '{value}''. If $filter is not provided, the unfiltered list includes all policy set definitions associated with
     * the management group, including those that apply directly or from management groups that contain the given
     * management group. If $filter=atExactScope() is provided, the returned list only includes all policy set
     * definitions that at the given management group. If $filter='policyType -eq {value}' is provided, the returned
     * list only includes all policy set definitions whose type match the {value}. Possible policyType values are
     * NotSpecified, BuiltIn and Custom. If $filter='category -eq {value}' is provided, the returned list only includes
     * all policy set definitions whose category match the {value}.
     * 
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atExactScope()', 'policyType
     * -eq {value}' or 'category eq '{value}''. If $filter is not provided, no filtering is performed. If
     * $filter=atExactScope() is provided, the returned list only includes all policy set definitions that at the given
     * scope. If $filter='policyType -eq {value}' is provided, the returned list only includes all policy set
     * definitions whose type match the {value}. Possible policyType values are NotSpecified, BuiltIn, Custom, and
     * Static. If $filter='category -eq {value}' is provided, the returned list only includes all policy set definitions
     * whose category match the {value}.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionInner> listByManagementGroup(String managementGroupId, String filter, Integer top,
        Context context);
}
