// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** The type of change that occurred. */
public enum ResourcePropertyChangeType {
    /** Enum value Update. */
    UPDATE("Update"),

    /** Enum value Insert. */
    INSERT("Insert"),

    /** Enum value Remove. */
    REMOVE("Remove");

    /** The actual serialized value for a ResourcePropertyChangeType instance. */
    private final String value;

    ResourcePropertyChangeType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResourcePropertyChangeType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ResourcePropertyChangeType object, or null if unable to parse.
     */
    @JsonCreator
    public static ResourcePropertyChangeType fromString(String value) {
        if (value == null) {
            return null;
        }
        ResourcePropertyChangeType[] items = ResourcePropertyChangeType.values();
        for (ResourcePropertyChangeType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
