// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Deployment parameter for the template. */
@Fluent
public final class DeploymentParameter {
    /*
     * Input value to the parameter .
     */
    @JsonProperty(value = "value")
    private Object value;

    /*
     * Azure Key Vault parameter reference.
     */
    @JsonProperty(value = "reference")
    private KeyVaultParameterReference reference;

    /** Creates an instance of DeploymentParameter class. */
    public DeploymentParameter() {
    }

    /**
     * Get the value property: Input value to the parameter .
     *
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: Input value to the parameter .
     *
     * @param value the value value to set.
     * @return the DeploymentParameter object itself.
     */
    public DeploymentParameter withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Get the reference property: Azure Key Vault parameter reference.
     *
     * @return the reference value.
     */
    public KeyVaultParameterReference reference() {
        return this.reference;
    }

    /**
     * Set the reference property: Azure Key Vault parameter reference.
     *
     * @param reference the reference value to set.
     * @return the DeploymentParameter object itself.
     */
    public DeploymentParameter withReference(KeyVaultParameterReference reference) {
        this.reference = reference;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (reference() != null) {
            reference().validate();
        }
    }
}
