// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Entity representing the reference to the template. */
@Fluent
public final class TemplateLink {
    /*
     * The URI of the template to deploy. Use either the uri or id property, but not both.
     */
    @JsonProperty(value = "uri")
    private String uri;

    /*
     * The resource id of a Template Spec. Use either the id or uri property, but not both.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The relativePath property can be used to deploy a linked template at a location relative to the parent. If the
     * parent template was linked with a TemplateSpec, this will reference an artifact in the TemplateSpec.  If the
     * parent was linked with a URI, the child deployment will be a combination of the parent and relativePath URIs
     */
    @JsonProperty(value = "relativePath")
    private String relativePath;

    /*
     * If included, must match the ContentVersion in the template.
     */
    @JsonProperty(value = "contentVersion")
    private String contentVersion;

    /*
     * The query string (for example, a SAS token) to be used with the templateLink URI.
     */
    @JsonProperty(value = "queryString")
    private String queryString;

    /** Creates an instance of TemplateLink class. */
    public TemplateLink() {
    }

    /**
     * Get the uri property: The URI of the template to deploy. Use either the uri or id property, but not both.
     *
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The URI of the template to deploy. Use either the uri or id property, but not both.
     *
     * @param uri the uri value to set.
     * @return the TemplateLink object itself.
     */
    public TemplateLink withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the id property: The resource id of a Template Spec. Use either the id or uri property, but not both.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The resource id of a Template Spec. Use either the id or uri property, but not both.
     *
     * @param id the id value to set.
     * @return the TemplateLink object itself.
     */
    public TemplateLink withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the relativePath property: The relativePath property can be used to deploy a linked template at a location
     * relative to the parent. If the parent template was linked with a TemplateSpec, this will reference an artifact in
     * the TemplateSpec. If the parent was linked with a URI, the child deployment will be a combination of the parent
     * and relativePath URIs.
     *
     * @return the relativePath value.
     */
    public String relativePath() {
        return this.relativePath;
    }

    /**
     * Set the relativePath property: The relativePath property can be used to deploy a linked template at a location
     * relative to the parent. If the parent template was linked with a TemplateSpec, this will reference an artifact in
     * the TemplateSpec. If the parent was linked with a URI, the child deployment will be a combination of the parent
     * and relativePath URIs.
     *
     * @param relativePath the relativePath value to set.
     * @return the TemplateLink object itself.
     */
    public TemplateLink withRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    /**
     * Get the contentVersion property: If included, must match the ContentVersion in the template.
     *
     * @return the contentVersion value.
     */
    public String contentVersion() {
        return this.contentVersion;
    }

    /**
     * Set the contentVersion property: If included, must match the ContentVersion in the template.
     *
     * @param contentVersion the contentVersion value to set.
     * @return the TemplateLink object itself.
     */
    public TemplateLink withContentVersion(String contentVersion) {
        this.contentVersion = contentVersion;
        return this;
    }

    /**
     * Get the queryString property: The query string (for example, a SAS token) to be used with the templateLink URI.
     *
     * @return the queryString value.
     */
    public String queryString() {
        return this.queryString;
    }

    /**
     * Set the queryString property: The query string (for example, a SAS token) to be used with the templateLink URI.
     *
     * @param queryString the queryString value to set.
     * @return the TemplateLink object itself.
     */
    public TemplateLink withQueryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
