// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.redis.fluent.AccessPolicyAssignmentsClient;
import com.azure.resourcemanager.redis.fluent.models.RedisCacheAccessPolicyAssignmentInner;
import com.azure.resourcemanager.redis.models.RedisCacheAccessPolicyAssignmentList;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in AccessPolicyAssignmentsClient.
 */
public final class AccessPolicyAssignmentsClientImpl implements AccessPolicyAssignmentsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final AccessPolicyAssignmentsService service;

    /**
     * The service client containing this operation class.
     */
    private final RedisManagementClientImpl client;

    /**
     * Initializes an instance of AccessPolicyAssignmentsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    AccessPolicyAssignmentsClientImpl(RedisManagementClientImpl client) {
        this.service = RestProxy.create(AccessPolicyAssignmentsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for RedisManagementClientAccessPolicyAssignments to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "RedisManagementClien")
    public interface AccessPolicyAssignmentsService {
        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicyAssignments/{accessPolicyAssignmentName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("cacheName") String cacheName,
            @PathParam("accessPolicyAssignmentName") String accessPolicyAssignmentName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") RedisCacheAccessPolicyAssignmentInner parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicyAssignments/{accessPolicyAssignmentName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("cacheName") String cacheName,
            @PathParam("accessPolicyAssignmentName") String accessPolicyAssignmentName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicyAssignments/{accessPolicyAssignmentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RedisCacheAccessPolicyAssignmentInner>> get(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("cacheName") String cacheName,
            @PathParam("accessPolicyAssignmentName") String accessPolicyAssignmentName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicyAssignments")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RedisCacheAccessPolicyAssignmentList>> list(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("cacheName") String cacheName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RedisCacheAccessPolicyAssignmentList>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to an operation on access policy assignment along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateWithResponseAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdate(this.client.getEndpoint(), resourceGroupName, cacheName,
                accessPolicyAssignmentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to an operation on access policy assignment along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateWithResponseAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdate(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyAssignmentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context);
    }

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner>
        beginCreateUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName,
            RedisCacheAccessPolicyAssignmentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createUpdateWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters);
        return this.client.<RedisCacheAccessPolicyAssignmentInner, RedisCacheAccessPolicyAssignmentInner>getLroResult(
            mono, this.client.getHttpPipeline(), RedisCacheAccessPolicyAssignmentInner.class,
            RedisCacheAccessPolicyAssignmentInner.class, this.client.getContext());
    }

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner>
        beginCreateUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName,
            RedisCacheAccessPolicyAssignmentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateWithResponseAsync(resourceGroupName, cacheName,
            accessPolicyAssignmentName, parameters, context);
        return this.client.<RedisCacheAccessPolicyAssignmentInner, RedisCacheAccessPolicyAssignmentInner>getLroResult(
            mono, this.client.getHttpPipeline(), RedisCacheAccessPolicyAssignmentInner.class,
            RedisCacheAccessPolicyAssignmentInner.class, context);
    }

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner>
        beginCreateUpdate(String resourceGroupName, String cacheName, String accessPolicyAssignmentName,
            RedisCacheAccessPolicyAssignmentInner parameters) {
        return this.beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters)
            .getSyncPoller();
    }

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner>
        beginCreateUpdate(String resourceGroupName, String cacheName, String accessPolicyAssignmentName,
            RedisCacheAccessPolicyAssignmentInner parameters, Context context) {
        return this
            .beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to an operation on access policy assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RedisCacheAccessPolicyAssignmentInner> createUpdateAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters) {
        return beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to an operation on access policy assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<RedisCacheAccessPolicyAssignmentInner> createUpdateAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters, Context context) {
        return beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RedisCacheAccessPolicyAssignmentInner createUpdate(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters) {
        return createUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters).block();
    }

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RedisCacheAccessPolicyAssignmentInner createUpdate(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters, Context context) {
        return createUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters, context).block();
    }

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, cacheName,
            accessPolicyAssignmentName, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyAssignmentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName).getSyncPoller();
    }

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, context).getSyncPoller();
    }

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName) {
        return beginDeleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName,
        Context context) {
        return beginDeleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String cacheName, String accessPolicyAssignmentName) {
        deleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName).block();
    }

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, Context context) {
        deleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, context).block();
    }

    /**
     * Gets the list of assignments for an access policy of a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of assignments for an access policy of a redis cache along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RedisCacheAccessPolicyAssignmentInner>> getWithResponseAsync(String resourceGroupName,
        String cacheName, String accessPolicyAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.get(this.client.getEndpoint(), resourceGroupName, cacheName,
            accessPolicyAssignmentName, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the list of assignments for an access policy of a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of assignments for an access policy of a redis cache along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RedisCacheAccessPolicyAssignmentInner>> getWithResponseAsync(String resourceGroupName,
        String cacheName, String accessPolicyAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyAssignmentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Gets the list of assignments for an access policy of a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of assignments for an access policy of a redis cache on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RedisCacheAccessPolicyAssignmentInner> getAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName) {
        return getWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the list of assignments for an access policy of a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of assignments for an access policy of a redis cache along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RedisCacheAccessPolicyAssignmentInner> getWithResponse(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, Context context) {
        return getWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, context).block();
    }

    /**
     * Gets the list of assignments for an access policy of a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of assignments for an access policy of a redis cache.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RedisCacheAccessPolicyAssignmentInner get(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName) {
        return getWithResponse(resourceGroupName, cacheName, accessPolicyAssignmentName, Context.NONE).getValue();
    }

    /**
     * Gets the list of access policy assignments associated with this redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of access policy assignments associated with this redis cache along with {@link PagedResponse}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyAssignmentInner>> listSinglePageAsync(String resourceGroupName,
        String cacheName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), resourceGroupName, cacheName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<RedisCacheAccessPolicyAssignmentInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the list of access policy assignments associated with this redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of access policy assignments associated with this redis cache along with {@link PagedResponse}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyAssignmentInner>> listSinglePageAsync(String resourceGroupName,
        String cacheName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), resourceGroupName, cacheName, this.client.getApiVersion(),
                this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets the list of access policy assignments associated with this redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of access policy assignments associated with this redis cache as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RedisCacheAccessPolicyAssignmentInner> listAsync(String resourceGroupName, String cacheName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, cacheName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the list of access policy assignments associated with this redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of access policy assignments associated with this redis cache as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RedisCacheAccessPolicyAssignmentInner> listAsync(String resourceGroupName, String cacheName,
        Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, cacheName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the list of access policy assignments associated with this redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of access policy assignments associated with this redis cache as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RedisCacheAccessPolicyAssignmentInner> list(String resourceGroupName, String cacheName) {
        return new PagedIterable<>(listAsync(resourceGroupName, cacheName));
    }

    /**
     * Gets the list of access policy assignments associated with this redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of access policy assignments associated with this redis cache as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RedisCacheAccessPolicyAssignmentInner> list(String resourceGroupName, String cacheName,
        Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, cacheName, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of access policies assignments (with properties) of a Redis cache along with {@link PagedResponse}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyAssignmentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<RedisCacheAccessPolicyAssignmentInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of access policies assignments (with properties) of a Redis cache along with {@link PagedResponse}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyAssignmentInner>> listNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
