// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.fluent.models.RedisResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of list Redis operation.
 */
@Fluent
public final class RedisListResult implements JsonSerializable<RedisListResult> {
    /*
     * List of Redis cache instances.
     */
    private List<RedisResourceInner> value;

    /*
     * Link for next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of RedisListResult class.
     */
    public RedisListResult() {
    }

    /**
     * Get the value property: List of Redis cache instances.
     * 
     * @return the value value.
     */
    public List<RedisResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of Redis cache instances.
     * 
     * @param value the value value to set.
     * @return the RedisListResult object itself.
     */
    public RedisListResult withValue(List<RedisResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link for next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RedisListResult.
     */
    public static RedisListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisListResult deserializedRedisListResult = new RedisListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RedisResourceInner> value = reader.readArray(reader1 -> RedisResourceInner.fromJson(reader1));
                    deserializedRedisListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRedisListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisListResult;
        });
    }
}
