// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.fluent.models.RedisLinkedServerCreateProperties;
import java.io.IOException;

/**
 * Parameter required for creating a linked server to redis cache.
 */
@Fluent
public final class RedisLinkedServerCreateParameters implements JsonSerializable<RedisLinkedServerCreateParameters> {
    /*
     * Properties required to create a linked server.
     */
    private RedisLinkedServerCreateProperties innerProperties = new RedisLinkedServerCreateProperties();

    /**
     * Creates an instance of RedisLinkedServerCreateParameters class.
     */
    public RedisLinkedServerCreateParameters() {
    }

    /**
     * Get the innerProperties property: Properties required to create a linked server.
     * 
     * @return the innerProperties value.
     */
    private RedisLinkedServerCreateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the linkedRedisCacheId property: Fully qualified resourceId of the linked redis cache.
     * 
     * @return the linkedRedisCacheId value.
     */
    public String linkedRedisCacheId() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRedisCacheId();
    }

    /**
     * Set the linkedRedisCacheId property: Fully qualified resourceId of the linked redis cache.
     * 
     * @param linkedRedisCacheId the linkedRedisCacheId value to set.
     * @return the RedisLinkedServerCreateParameters object itself.
     */
    public RedisLinkedServerCreateParameters withLinkedRedisCacheId(String linkedRedisCacheId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerCreateProperties();
        }
        this.innerProperties().withLinkedRedisCacheId(linkedRedisCacheId);
        return this;
    }

    /**
     * Get the linkedRedisCacheLocation property: Location of the linked redis cache.
     * 
     * @return the linkedRedisCacheLocation value.
     */
    public String linkedRedisCacheLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRedisCacheLocation();
    }

    /**
     * Set the linkedRedisCacheLocation property: Location of the linked redis cache.
     * 
     * @param linkedRedisCacheLocation the linkedRedisCacheLocation value to set.
     * @return the RedisLinkedServerCreateParameters object itself.
     */
    public RedisLinkedServerCreateParameters withLinkedRedisCacheLocation(String linkedRedisCacheLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerCreateProperties();
        }
        this.innerProperties().withLinkedRedisCacheLocation(linkedRedisCacheLocation);
        return this;
    }

    /**
     * Get the serverRole property: Role of the linked server.
     * 
     * @return the serverRole value.
     */
    public ReplicationRole serverRole() {
        return this.innerProperties() == null ? null : this.innerProperties().serverRole();
    }

    /**
     * Set the serverRole property: Role of the linked server.
     * 
     * @param serverRole the serverRole value to set.
     * @return the RedisLinkedServerCreateParameters object itself.
     */
    public RedisLinkedServerCreateParameters withServerRole(ReplicationRole serverRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerCreateProperties();
        }
        this.innerProperties().withServerRole(serverRole);
        return this;
    }

    /**
     * Get the geoReplicatedPrimaryHostname property: The unchanging DNS name which will always point to current
     * geo-primary cache among the linked redis caches for seamless Geo Failover experience.
     * 
     * @return the geoReplicatedPrimaryHostname value.
     */
    public String geoReplicatedPrimaryHostname() {
        return this.innerProperties() == null ? null : this.innerProperties().geoReplicatedPrimaryHostname();
    }

    /**
     * Get the primaryHostname property: The changing DNS name that resolves to the current geo-primary cache among the
     * linked redis caches before or after the Geo Failover.
     * 
     * @return the primaryHostname value.
     */
    public String primaryHostname() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryHostname();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model RedisLinkedServerCreateParameters"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisLinkedServerCreateParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisLinkedServerCreateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisLinkedServerCreateParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RedisLinkedServerCreateParameters.
     */
    public static RedisLinkedServerCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisLinkedServerCreateParameters deserializedRedisLinkedServerCreateParameters
                = new RedisLinkedServerCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateParameters.innerProperties
                        = RedisLinkedServerCreateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisLinkedServerCreateParameters;
        });
    }
}
