// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.ScheduleEntry;
import java.io.IOException;
import java.util.List;

/**
 * List of patch schedules for a Redis cache.
 */
@Fluent
public final class ScheduleEntries implements JsonSerializable<ScheduleEntries> {
    /*
     * List of patch schedules for a Redis cache.
     */
    private List<ScheduleEntry> scheduleEntries;

    /**
     * Creates an instance of ScheduleEntries class.
     */
    public ScheduleEntries() {
    }

    /**
     * Get the scheduleEntries property: List of patch schedules for a Redis cache.
     * 
     * @return the scheduleEntries value.
     */
    public List<ScheduleEntry> scheduleEntries() {
        return this.scheduleEntries;
    }

    /**
     * Set the scheduleEntries property: List of patch schedules for a Redis cache.
     * 
     * @param scheduleEntries the scheduleEntries value to set.
     * @return the ScheduleEntries object itself.
     */
    public ScheduleEntries withScheduleEntries(List<ScheduleEntry> scheduleEntries) {
        this.scheduleEntries = scheduleEntries;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scheduleEntries() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property scheduleEntries in model ScheduleEntries"));
        } else {
            scheduleEntries().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ScheduleEntries.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("scheduleEntries", this.scheduleEntries,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScheduleEntries from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScheduleEntries if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ScheduleEntries.
     */
    public static ScheduleEntries fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScheduleEntries deserializedScheduleEntries = new ScheduleEntries();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scheduleEntries".equals(fieldName)) {
                    List<ScheduleEntry> scheduleEntries = reader.readArray(reader1 -> ScheduleEntry.fromJson(reader1));
                    deserializedScheduleEntries.scheduleEntries = scheduleEntries;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScheduleEntries;
        });
    }
}
