// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.ScheduleEntry;
import java.io.IOException;
import java.util.List;

/**
 * Response to put/get patch schedules for Redis cache.
 */
@Fluent
public final class RedisPatchScheduleInner extends ProxyResource {
    /*
     * List of patch schedules for a Redis cache.
     */
    private ScheduleEntries innerProperties = new ScheduleEntries();

    /*
     * The geo-location where the resource lives
     */
    private String location;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RedisPatchScheduleInner class.
     */
    public RedisPatchScheduleInner() {
    }

    /**
     * Get the innerProperties property: List of patch schedules for a Redis cache.
     * 
     * @return the innerProperties value.
     */
    private ScheduleEntries innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the location property: The geo-location where the resource lives.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the scheduleEntries property: List of patch schedules for a Redis cache.
     * 
     * @return the scheduleEntries value.
     */
    public List<ScheduleEntry> scheduleEntries() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduleEntries();
    }

    /**
     * Set the scheduleEntries property: List of patch schedules for a Redis cache.
     * 
     * @param scheduleEntries the scheduleEntries value to set.
     * @return the RedisPatchScheduleInner object itself.
     */
    public RedisPatchScheduleInner withScheduleEntries(List<ScheduleEntry> scheduleEntries) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleEntries();
        }
        this.innerProperties().withScheduleEntries(scheduleEntries);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model RedisPatchScheduleInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisPatchScheduleInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisPatchScheduleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisPatchScheduleInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RedisPatchScheduleInner.
     */
    public static RedisPatchScheduleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisPatchScheduleInner deserializedRedisPatchScheduleInner = new RedisPatchScheduleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRedisPatchScheduleInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRedisPatchScheduleInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRedisPatchScheduleInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRedisPatchScheduleInner.innerProperties = ScheduleEntries.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedRedisPatchScheduleInner.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisPatchScheduleInner;
        });
    }
}
