// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Response to force reboot for Redis cache.
 */
@Immutable
public final class RedisForceRebootResponseInner implements JsonSerializable<RedisForceRebootResponseInner> {
    /*
     * Status message
     */
    private String message;

    /**
     * Creates an instance of RedisForceRebootResponseInner class.
     */
    public RedisForceRebootResponseInner() {
    }

    /**
     * Get the message property: Status message.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisForceRebootResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisForceRebootResponseInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RedisForceRebootResponseInner.
     */
    public static RedisForceRebootResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisForceRebootResponseInner deserializedRedisForceRebootResponseInner
                = new RedisForceRebootResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("message".equals(fieldName)) {
                    deserializedRedisForceRebootResponseInner.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisForceRebootResponseInner;
        });
    }
}
