// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect.
 */
@Fluent
public class RedisFirewallRuleInner extends ProxyResource {
    /*
     * redis cache firewall rule properties
     */
    private RedisFirewallRuleProperties innerProperties = new RedisFirewallRuleProperties();

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RedisFirewallRuleInner class.
     */
    public RedisFirewallRuleInner() {
    }

    /**
     * Get the innerProperties property: redis cache firewall rule properties.
     * 
     * @return the innerProperties value.
     */
    private RedisFirewallRuleProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Set the innerProperties property: redis cache firewall rule properties.
     * 
     * @param innerProperties the innerProperties value to set.
     * @return the RedisFirewallRuleInner object itself.
     */
    RedisFirewallRuleInner withInnerProperties(RedisFirewallRuleProperties innerProperties) {
        this.innerProperties = innerProperties;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the startIp property: lowest IP address included in the range.
     * 
     * @return the startIp value.
     */
    public String startIp() {
        return this.innerProperties() == null ? null : this.innerProperties().startIp();
    }

    /**
     * Set the startIp property: lowest IP address included in the range.
     * 
     * @param startIp the startIp value to set.
     * @return the RedisFirewallRuleInner object itself.
     */
    public RedisFirewallRuleInner withStartIp(String startIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisFirewallRuleProperties();
        }
        this.innerProperties().withStartIp(startIp);
        return this;
    }

    /**
     * Get the endIp property: highest IP address included in the range.
     * 
     * @return the endIp value.
     */
    public String endIp() {
        return this.innerProperties() == null ? null : this.innerProperties().endIp();
    }

    /**
     * Set the endIp property: highest IP address included in the range.
     * 
     * @param endIp the endIp value to set.
     * @return the RedisFirewallRuleInner object itself.
     */
    public RedisFirewallRuleInner withEndIp(String endIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisFirewallRuleProperties();
        }
        this.innerProperties().withEndIp(endIp);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model RedisFirewallRuleInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisFirewallRuleInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisFirewallRuleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisFirewallRuleInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RedisFirewallRuleInner.
     */
    public static RedisFirewallRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisFirewallRuleInner deserializedRedisFirewallRuleInner = new RedisFirewallRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRedisFirewallRuleInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRedisFirewallRuleInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRedisFirewallRuleInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRedisFirewallRuleInner.innerProperties = RedisFirewallRuleProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisFirewallRuleInner;
        });
    }
}
