// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Redis cache access keys.
 */
@Immutable
public final class RedisAccessKeysInner implements JsonSerializable<RedisAccessKeysInner> {
    /*
     * The current primary key that clients can use to authenticate with Redis cache.
     */
    private String primaryKey;

    /*
     * The current secondary key that clients can use to authenticate with Redis cache.
     */
    private String secondaryKey;

    /**
     * Creates an instance of RedisAccessKeysInner class.
     */
    public RedisAccessKeysInner() {
    }

    /**
     * Get the primaryKey property: The current primary key that clients can use to authenticate with Redis cache.
     * 
     * @return the primaryKey value.
     */
    public String primaryKey() {
        return this.primaryKey;
    }

    /**
     * Get the secondaryKey property: The current secondary key that clients can use to authenticate with Redis cache.
     * 
     * @return the secondaryKey value.
     */
    public String secondaryKey() {
        return this.secondaryKey;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisAccessKeysInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisAccessKeysInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RedisAccessKeysInner.
     */
    public static RedisAccessKeysInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisAccessKeysInner deserializedRedisAccessKeysInner = new RedisAccessKeysInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("primaryKey".equals(fieldName)) {
                    deserializedRedisAccessKeysInner.primaryKey = reader.getString();
                } else if ("secondaryKey".equals(fieldName)) {
                    deserializedRedisAccessKeysInner.secondaryKey = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisAccessKeysInner;
        });
    }
}
