// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SKU parameters supplied to the create Redis operation.
 */
@Fluent
public final class Sku implements JsonSerializable<Sku> {
    /*
     * The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium)
     */
    private SkuName name;

    /*
     * The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
     */
    private SkuFamily family;

    /*
     * The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P
     * (Premium) family (1, 2, 3, 4).
     */
    private int capacity;

    /**
     * Creates an instance of Sku class.
     */
    public Sku() {
    }

    /**
     * Get the name property: The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium).
     * 
     * @return the name value.
     */
    public SkuName name() {
        return this.name;
    }

    /**
     * Set the name property: The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium).
     * 
     * @param name the name value to set.
     * @return the Sku object itself.
     */
    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the family property: The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
     * 
     * @return the family value.
     */
    public SkuFamily family() {
        return this.family;
    }

    /**
     * Set the family property: The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
     * 
     * @param family the family value to set.
     * @return the Sku object itself.
     */
    public Sku withFamily(SkuFamily family) {
        this.family = family;
        return this;
    }

    /**
     * Get the capacity property: The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0,
     * 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4).
     * 
     * @return the capacity value.
     */
    public int capacity() {
        return this.capacity;
    }

    /**
     * Set the capacity property: The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0,
     * 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4).
     * 
     * @param capacity the capacity value to set.
     * @return the Sku object itself.
     */
    public Sku withCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model Sku"));
        }
        if (family() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property family in model Sku"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Sku.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("family", this.family == null ? null : this.family.toString());
        jsonWriter.writeIntField("capacity", this.capacity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Sku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Sku if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Sku.
     */
    public static Sku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Sku deserializedSku = new Sku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSku.name = SkuName.fromString(reader.getString());
                } else if ("family".equals(fieldName)) {
                    deserializedSku.family = SkuFamily.fromString(reader.getString());
                } else if ("capacity".equals(fieldName)) {
                    deserializedSku.capacity = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSku;
        });
    }
}
