// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.fluent.models.RedisFirewallRuleInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of list firewall rules Redis operation.
 */
@Fluent
public final class RedisFirewallRuleListResult implements JsonSerializable<RedisFirewallRuleListResult> {
    /*
     * Results of the list firewall rules operation.
     */
    private List<RedisFirewallRuleInner> value;

    /*
     * Link for next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of RedisFirewallRuleListResult class.
     */
    public RedisFirewallRuleListResult() {
    }

    /**
     * Get the value property: Results of the list firewall rules operation.
     * 
     * @return the value value.
     */
    public List<RedisFirewallRuleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Results of the list firewall rules operation.
     * 
     * @param value the value value to set.
     * @return the RedisFirewallRuleListResult object itself.
     */
    public RedisFirewallRuleListResult withValue(List<RedisFirewallRuleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link for next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisFirewallRuleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisFirewallRuleListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RedisFirewallRuleListResult.
     */
    public static RedisFirewallRuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisFirewallRuleListResult deserializedRedisFirewallRuleListResult = new RedisFirewallRuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RedisFirewallRuleInner> value
                        = reader.readArray(reader1 -> RedisFirewallRuleInner.fromJson(reader1));
                    deserializedRedisFirewallRuleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRedisFirewallRuleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisFirewallRuleListResult;
        });
    }
}
