// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies which Redis access keys to reset.
 */
@Fluent
public final class RedisRegenerateKeyParameters {
    /*
     * The Redis access key to regenerate.
     */
    @JsonProperty(value = "keyType", required = true)
    private RedisKeyType keyType;

    /**
     * Creates an instance of RedisRegenerateKeyParameters class.
     */
    public RedisRegenerateKeyParameters() {
    }

    /**
     * Get the keyType property: The Redis access key to regenerate.
     * 
     * @return the keyType value.
     */
    public RedisKeyType keyType() {
        return this.keyType;
    }

    /**
     * Set the keyType property: The Redis access key to regenerate.
     * 
     * @param keyType the keyType value to set.
     * @return the RedisRegenerateKeyParameters object itself.
     */
    public RedisRegenerateKeyParameters withKeyType(RedisKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property keyType in model RedisRegenerateKeyParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisRegenerateKeyParameters.class);
}
