// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Create/Update/Get common properties of the redis cache.
 */
@Fluent
public class RedisCommonProperties {
    /*
     * All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,
     * maxmemory-policy,notify-keyspace-events, aof-backup-enabled, aof-storage-connection-string-0,
     * aof-storage-connection-string-1 etc.
     */
    @JsonProperty(value = "redisConfiguration")
    private RedisConfiguration redisConfiguration;

    /*
     * Redis version. This should be in the form 'major[.minor]' (only 'major' is required) or the value 'latest' which
     * refers to the latest stable Redis version that is available. Supported versions: 4.0, 6.0 (latest). Default value
     * is 'latest'.
     */
    @JsonProperty(value = "redisVersion")
    private String redisVersion;

    /*
     * Specifies whether the non-ssl Redis server port (6379) is enabled.
     */
    @JsonProperty(value = "enableNonSslPort")
    private Boolean enableNonSslPort;

    /*
     * The number of replicas to be created per primary.
     */
    @JsonProperty(value = "replicasPerMaster")
    private Integer replicasPerMaster;

    /*
     * The number of replicas to be created per primary.
     */
    @JsonProperty(value = "replicasPerPrimary")
    private Integer replicasPerPrimary;

    /*
     * A dictionary of tenant settings
     */
    @JsonProperty(value = "tenantSettings")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tenantSettings;

    /*
     * The number of shards to be created on a Premium Cluster Cache.
     */
    @JsonProperty(value = "shardCount")
    private Integer shardCount;

    /*
     * Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
     */
    @JsonProperty(value = "minimumTlsVersion")
    private TlsVersion minimumTlsVersion;

    /*
     * Whether or not public endpoint access is allowed for this cache. Value is optional but if passed in, must be
     * 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is
     * 'Enabled'
     */
    @JsonProperty(value = "publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * Optional: Specifies the update channel for the monthly Redis updates your Redis Cache will receive. Caches using
     * 'Preview' update channel get latest Redis updates at least 4 weeks ahead of 'Stable' channel caches. Default
     * value is 'Stable'.
     */
    @JsonProperty(value = "updateChannel")
    private UpdateChannel updateChannel;

    /*
     * Authentication to Redis through access keys is disabled when set as true. Default value is false.
     */
    @JsonProperty(value = "disableAccessKeyAuthentication")
    private Boolean disableAccessKeyAuthentication;

    /**
     * Creates an instance of RedisCommonProperties class.
     */
    public RedisCommonProperties() {
    }

    /**
     * Get the redisConfiguration property: All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,
     * maxmemory-policy,notify-keyspace-events, aof-backup-enabled, aof-storage-connection-string-0,
     * aof-storage-connection-string-1 etc.
     * 
     * @return the redisConfiguration value.
     */
    public RedisConfiguration redisConfiguration() {
        return this.redisConfiguration;
    }

    /**
     * Set the redisConfiguration property: All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,
     * maxmemory-policy,notify-keyspace-events, aof-backup-enabled, aof-storage-connection-string-0,
     * aof-storage-connection-string-1 etc.
     * 
     * @param redisConfiguration the redisConfiguration value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withRedisConfiguration(RedisConfiguration redisConfiguration) {
        this.redisConfiguration = redisConfiguration;
        return this;
    }

    /**
     * Get the redisVersion property: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     * required) or the value 'latest' which refers to the latest stable Redis version that is available. Supported
     * versions: 4.0, 6.0 (latest). Default value is 'latest'.
     * 
     * @return the redisVersion value.
     */
    public String redisVersion() {
        return this.redisVersion;
    }

    /**
     * Set the redisVersion property: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     * required) or the value 'latest' which refers to the latest stable Redis version that is available. Supported
     * versions: 4.0, 6.0 (latest). Default value is 'latest'.
     * 
     * @param redisVersion the redisVersion value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withRedisVersion(String redisVersion) {
        this.redisVersion = redisVersion;
        return this;
    }

    /**
     * Get the enableNonSslPort property: Specifies whether the non-ssl Redis server port (6379) is enabled.
     * 
     * @return the enableNonSslPort value.
     */
    public Boolean enableNonSslPort() {
        return this.enableNonSslPort;
    }

    /**
     * Set the enableNonSslPort property: Specifies whether the non-ssl Redis server port (6379) is enabled.
     * 
     * @param enableNonSslPort the enableNonSslPort value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withEnableNonSslPort(Boolean enableNonSslPort) {
        this.enableNonSslPort = enableNonSslPort;
        return this;
    }

    /**
     * Get the replicasPerMaster property: The number of replicas to be created per primary.
     * 
     * @return the replicasPerMaster value.
     */
    public Integer replicasPerMaster() {
        return this.replicasPerMaster;
    }

    /**
     * Set the replicasPerMaster property: The number of replicas to be created per primary.
     * 
     * @param replicasPerMaster the replicasPerMaster value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withReplicasPerMaster(Integer replicasPerMaster) {
        this.replicasPerMaster = replicasPerMaster;
        return this;
    }

    /**
     * Get the replicasPerPrimary property: The number of replicas to be created per primary.
     * 
     * @return the replicasPerPrimary value.
     */
    public Integer replicasPerPrimary() {
        return this.replicasPerPrimary;
    }

    /**
     * Set the replicasPerPrimary property: The number of replicas to be created per primary.
     * 
     * @param replicasPerPrimary the replicasPerPrimary value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withReplicasPerPrimary(Integer replicasPerPrimary) {
        this.replicasPerPrimary = replicasPerPrimary;
        return this;
    }

    /**
     * Get the tenantSettings property: A dictionary of tenant settings.
     * 
     * @return the tenantSettings value.
     */
    public Map<String, String> tenantSettings() {
        return this.tenantSettings;
    }

    /**
     * Set the tenantSettings property: A dictionary of tenant settings.
     * 
     * @param tenantSettings the tenantSettings value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withTenantSettings(Map<String, String> tenantSettings) {
        this.tenantSettings = tenantSettings;
        return this;
    }

    /**
     * Get the shardCount property: The number of shards to be created on a Premium Cluster Cache.
     * 
     * @return the shardCount value.
     */
    public Integer shardCount() {
        return this.shardCount;
    }

    /**
     * Set the shardCount property: The number of shards to be created on a Premium Cluster Cache.
     * 
     * @param shardCount the shardCount value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withShardCount(Integer shardCount) {
        this.shardCount = shardCount;
        return this;
    }

    /**
     * Get the minimumTlsVersion property: Optional: requires clients to use a specified TLS version (or higher) to
     * connect (e,g, '1.0', '1.1', '1.2').
     * 
     * @return the minimumTlsVersion value.
     */
    public TlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    /**
     * Set the minimumTlsVersion property: Optional: requires clients to use a specified TLS version (or higher) to
     * connect (e,g, '1.0', '1.1', '1.2').
     * 
     * @param minimumTlsVersion the minimumTlsVersion value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public endpoint access is allowed for this cache. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive
     * access method. Default value is 'Enabled'.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public endpoint access is allowed for this cache. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive
     * access method. Default value is 'Enabled'.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the updateChannel property: Optional: Specifies the update channel for the monthly Redis updates your Redis
     * Cache will receive. Caches using 'Preview' update channel get latest Redis updates at least 4 weeks ahead of
     * 'Stable' channel caches. Default value is 'Stable'.
     * 
     * @return the updateChannel value.
     */
    public UpdateChannel updateChannel() {
        return this.updateChannel;
    }

    /**
     * Set the updateChannel property: Optional: Specifies the update channel for the monthly Redis updates your Redis
     * Cache will receive. Caches using 'Preview' update channel get latest Redis updates at least 4 weeks ahead of
     * 'Stable' channel caches. Default value is 'Stable'.
     * 
     * @param updateChannel the updateChannel value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withUpdateChannel(UpdateChannel updateChannel) {
        this.updateChannel = updateChannel;
        return this;
    }

    /**
     * Get the disableAccessKeyAuthentication property: Authentication to Redis through access keys is disabled when set
     * as true. Default value is false.
     * 
     * @return the disableAccessKeyAuthentication value.
     */
    public Boolean disableAccessKeyAuthentication() {
        return this.disableAccessKeyAuthentication;
    }

    /**
     * Set the disableAccessKeyAuthentication property: Authentication to Redis through access keys is disabled when set
     * as true. Default value is false.
     * 
     * @param disableAccessKeyAuthentication the disableAccessKeyAuthentication value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        this.disableAccessKeyAuthentication = disableAccessKeyAuthentication;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (redisConfiguration() != null) {
            redisConfiguration().validate();
        }
    }
}
