// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.redis.models.ReplicationRole;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of a linked server to be returned in get/put response.
 */
@Fluent
public final class RedisLinkedServerProperties extends RedisLinkedServerCreateProperties {
    /*
     * Terminal state of the link between primary and secondary redis cache.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /**
     * Creates an instance of RedisLinkedServerProperties class.
     */
    public RedisLinkedServerProperties() {
    }

    /**
     * Get the provisioningState property: Terminal state of the link between primary and secondary redis cache.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RedisLinkedServerProperties withLinkedRedisCacheId(String linkedRedisCacheId) {
        super.withLinkedRedisCacheId(linkedRedisCacheId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RedisLinkedServerProperties withLinkedRedisCacheLocation(String linkedRedisCacheLocation) {
        super.withLinkedRedisCacheLocation(linkedRedisCacheLocation);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RedisLinkedServerProperties withServerRole(ReplicationRole serverRole) {
        super.withServerRole(serverRole);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
