// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies a range of IP addresses permitted to connect to the cache.
 */
@Fluent
public final class RedisFirewallRuleProperties {
    /*
     * lowest IP address included in the range
     */
    @JsonProperty(value = "startIP", required = true)
    private String startIp;

    /*
     * highest IP address included in the range
     */
    @JsonProperty(value = "endIP", required = true)
    private String endIp;

    /**
     * Creates an instance of RedisFirewallRuleProperties class.
     */
    public RedisFirewallRuleProperties() {
    }

    /**
     * Get the startIp property: lowest IP address included in the range.
     * 
     * @return the startIp value.
     */
    public String startIp() {
        return this.startIp;
    }

    /**
     * Set the startIp property: lowest IP address included in the range.
     * 
     * @param startIp the startIp value to set.
     * @return the RedisFirewallRuleProperties object itself.
     */
    public RedisFirewallRuleProperties withStartIp(String startIp) {
        this.startIp = startIp;
        return this;
    }

    /**
     * Get the endIp property: highest IP address included in the range.
     * 
     * @return the endIp value.
     */
    public String endIp() {
        return this.endIp;
    }

    /**
     * Set the endIp property: highest IP address included in the range.
     * 
     * @param endIp the endIp value to set.
     * @return the RedisFirewallRuleProperties object itself.
     */
    public RedisFirewallRuleProperties withEndIp(String endIp) {
        this.endIp = endIp;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (startIp() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property startIp in model RedisFirewallRuleProperties"));
        }
        if (endIp() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property endIp in model RedisFirewallRuleProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisFirewallRuleProperties.class);
}
