// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect.
 */
@Fluent
public class RedisFirewallRuleInner extends ProxyResource {
    /*
     * redis cache firewall rule properties
     */
    @JsonProperty(value = "properties", required = true)
    private RedisFirewallRuleProperties innerProperties = new RedisFirewallRuleProperties();

    /**
     * Creates an instance of RedisFirewallRuleInner class.
     */
    public RedisFirewallRuleInner() {
    }

    /**
     * Get the innerProperties property: redis cache firewall rule properties.
     * 
     * @return the innerProperties value.
     */
    private RedisFirewallRuleProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the startIp property: lowest IP address included in the range.
     * 
     * @return the startIp value.
     */
    public String startIp() {
        return this.innerProperties() == null ? null : this.innerProperties().startIp();
    }

    /**
     * Set the startIp property: lowest IP address included in the range.
     * 
     * @param startIp the startIp value to set.
     * @return the RedisFirewallRuleInner object itself.
     */
    public RedisFirewallRuleInner withStartIp(String startIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisFirewallRuleProperties();
        }
        this.innerProperties().withStartIp(startIp);
        return this;
    }

    /**
     * Get the endIp property: highest IP address included in the range.
     * 
     * @return the endIp value.
     */
    public String endIp() {
        return this.innerProperties() == null ? null : this.innerProperties().endIp();
    }

    /**
     * Set the endIp property: highest IP address included in the range.
     * 
     * @param endIp the endIp value to set.
     * @return the RedisFirewallRuleInner object itself.
     */
    public RedisFirewallRuleInner withEndIp(String endIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisFirewallRuleProperties();
        }
        this.innerProperties().withEndIp(endIp);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model RedisFirewallRuleInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisFirewallRuleInner.class);
}
