// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.models.AccessPolicyProvisioningState;
import com.azure.resourcemanager.redis.models.AccessPolicyType;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * All properties of an access policy.
 */
@Fluent
public final class RedisCacheAccessPolicyProperties {
    /*
     * Provisioning state of access policy
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private AccessPolicyProvisioningState provisioningState;

    /*
     * Built-In or Custom access policy
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private AccessPolicyType type;

    /*
     * Permissions for the access policy. Learn how to configure permissions at https://aka.ms/redis/AADPreRequisites
     */
    @JsonProperty(value = "permissions", required = true)
    private String permissions;

    /**
     * Creates an instance of RedisCacheAccessPolicyProperties class.
     */
    public RedisCacheAccessPolicyProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of access policy.
     * 
     * @return the provisioningState value.
     */
    public AccessPolicyProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the type property: Built-In or Custom access policy.
     * 
     * @return the type value.
     */
    public AccessPolicyType type() {
        return this.type;
    }

    /**
     * Get the permissions property: Permissions for the access policy. Learn how to configure permissions at
     * https://aka.ms/redis/AADPreRequisites.
     * 
     * @return the permissions value.
     */
    public String permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: Permissions for the access policy. Learn how to configure permissions at
     * https://aka.ms/redis/AADPreRequisites.
     * 
     * @param permissions the permissions value to set.
     * @return the RedisCacheAccessPolicyProperties object itself.
     */
    public RedisCacheAccessPolicyProperties withPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (permissions() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property permissions in model RedisCacheAccessPolicyProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisCacheAccessPolicyProperties.class);
}
