// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.redis.models.AccessPolicyProvisioningState;
import com.azure.resourcemanager.redis.models.AccessPolicyType;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Response to get/put access policy.
 */
@Fluent
public final class RedisCacheAccessPolicyInner extends ProxyResource {
    /*
     * Properties of an access policy.
     */
    @JsonProperty(value = "properties")
    private RedisCacheAccessPolicyProperties innerProperties;

    /**
     * Creates an instance of RedisCacheAccessPolicyInner class.
     */
    public RedisCacheAccessPolicyInner() {
    }

    /**
     * Get the innerProperties property: Properties of an access policy.
     * 
     * @return the innerProperties value.
     */
    private RedisCacheAccessPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the provisioningState property: Provisioning state of access policy.
     * 
     * @return the provisioningState value.
     */
    public AccessPolicyProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the type property: Built-In or Custom access policy.
     * 
     * @return the type value.
     */
    public AccessPolicyType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Get the permissions property: Permissions for the access policy. Learn how to configure permissions at
     * https://aka.ms/redis/AADPreRequisites.
     * 
     * @return the permissions value.
     */
    public String permissions() {
        return this.innerProperties() == null ? null : this.innerProperties().permissions();
    }

    /**
     * Set the permissions property: Permissions for the access policy. Learn how to configure permissions at
     * https://aka.ms/redis/AADPreRequisites.
     * 
     * @param permissions the permissions value to set.
     * @return the RedisCacheAccessPolicyInner object itself.
     */
    public RedisCacheAccessPolicyInner withPermissions(String permissions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCacheAccessPolicyProperties();
        }
        this.innerProperties().withPermissions(permissions);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
