// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.models.AccessPolicyAssignmentProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties for an access policy assignment.
 */
@Fluent
public final class RedisCacheAccessPolicyAssignmentProperties {
    /*
     * Provisioning state of an access policy assignment set
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private AccessPolicyAssignmentProvisioningState provisioningState;

    /*
     * Object Id to assign access policy to
     */
    @JsonProperty(value = "objectId", required = true)
    private String objectId;

    /*
     * User friendly name for object id. Also represents username for token based authentication
     */
    @JsonProperty(value = "objectIdAlias", required = true)
    private String objectIdAlias;

    /*
     * The name of the access policy that is being assigned
     */
    @JsonProperty(value = "accessPolicyName", required = true)
    private String accessPolicyName;

    /**
     * Creates an instance of RedisCacheAccessPolicyAssignmentProperties class.
     */
    public RedisCacheAccessPolicyAssignmentProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of an access policy assignment set.
     * 
     * @return the provisioningState value.
     */
    public AccessPolicyAssignmentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the objectId property: Object Id to assign access policy to.
     * 
     * @return the objectId value.
     */
    public String objectId() {
        return this.objectId;
    }

    /**
     * Set the objectId property: Object Id to assign access policy to.
     * 
     * @param objectId the objectId value to set.
     * @return the RedisCacheAccessPolicyAssignmentProperties object itself.
     */
    public RedisCacheAccessPolicyAssignmentProperties withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    /**
     * Get the objectIdAlias property: User friendly name for object id. Also represents username for token based
     * authentication.
     * 
     * @return the objectIdAlias value.
     */
    public String objectIdAlias() {
        return this.objectIdAlias;
    }

    /**
     * Set the objectIdAlias property: User friendly name for object id. Also represents username for token based
     * authentication.
     * 
     * @param objectIdAlias the objectIdAlias value to set.
     * @return the RedisCacheAccessPolicyAssignmentProperties object itself.
     */
    public RedisCacheAccessPolicyAssignmentProperties withObjectIdAlias(String objectIdAlias) {
        this.objectIdAlias = objectIdAlias;
        return this;
    }

    /**
     * Get the accessPolicyName property: The name of the access policy that is being assigned.
     * 
     * @return the accessPolicyName value.
     */
    public String accessPolicyName() {
        return this.accessPolicyName;
    }

    /**
     * Set the accessPolicyName property: The name of the access policy that is being assigned.
     * 
     * @param accessPolicyName the accessPolicyName value to set.
     * @return the RedisCacheAccessPolicyAssignmentProperties object itself.
     */
    public RedisCacheAccessPolicyAssignmentProperties withAccessPolicyName(String accessPolicyName) {
        this.accessPolicyName = accessPolicyName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (objectId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property objectId in model RedisCacheAccessPolicyAssignmentProperties"));
        }
        if (objectIdAlias() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property objectIdAlias in model RedisCacheAccessPolicyAssignmentProperties"));
        }
        if (accessPolicyName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property accessPolicyName in model RedisCacheAccessPolicyAssignmentProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisCacheAccessPolicyAssignmentProperties.class);
}
