// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.redis.models.AccessPolicyAssignmentProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Response to an operation on access policy assignment. */
@Fluent
public final class RedisCacheAccessPolicyAssignmentInner extends ProxyResource {
    /*
     * Properties of an access policy assignment
     */
    @JsonProperty(value = "properties")
    private RedisCacheAccessPolicyAssignmentProperties innerProperties;

    /** Creates an instance of RedisCacheAccessPolicyAssignmentInner class. */
    public RedisCacheAccessPolicyAssignmentInner() {
    }

    /**
     * Get the innerProperties property: Properties of an access policy assignment.
     *
     * @return the innerProperties value.
     */
    private RedisCacheAccessPolicyAssignmentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the provisioningState property: Provisioning state of an access policy assignment set.
     *
     * @return the provisioningState value.
     */
    public AccessPolicyAssignmentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the objectId property: Object Id to assign access policy to.
     *
     * @return the objectId value.
     */
    public String objectId() {
        return this.innerProperties() == null ? null : this.innerProperties().objectId();
    }

    /**
     * Set the objectId property: Object Id to assign access policy to.
     *
     * @param objectId the objectId value to set.
     * @return the RedisCacheAccessPolicyAssignmentInner object itself.
     */
    public RedisCacheAccessPolicyAssignmentInner withObjectId(String objectId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCacheAccessPolicyAssignmentProperties();
        }
        this.innerProperties().withObjectId(objectId);
        return this;
    }

    /**
     * Get the objectIdAlias property: User friendly name for object id. Also represents username for token based
     * authentication.
     *
     * @return the objectIdAlias value.
     */
    public String objectIdAlias() {
        return this.innerProperties() == null ? null : this.innerProperties().objectIdAlias();
    }

    /**
     * Set the objectIdAlias property: User friendly name for object id. Also represents username for token based
     * authentication.
     *
     * @param objectIdAlias the objectIdAlias value to set.
     * @return the RedisCacheAccessPolicyAssignmentInner object itself.
     */
    public RedisCacheAccessPolicyAssignmentInner withObjectIdAlias(String objectIdAlias) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCacheAccessPolicyAssignmentProperties();
        }
        this.innerProperties().withObjectIdAlias(objectIdAlias);
        return this;
    }

    /**
     * Get the accessPolicyName property: The name of the access policy that is being assigned.
     *
     * @return the accessPolicyName value.
     */
    public String accessPolicyName() {
        return this.innerProperties() == null ? null : this.innerProperties().accessPolicyName();
    }

    /**
     * Set the accessPolicyName property: The name of the access policy that is being assigned.
     *
     * @param accessPolicyName the accessPolicyName value to set.
     * @return the RedisCacheAccessPolicyAssignmentInner object itself.
     */
    public RedisCacheAccessPolicyAssignmentInner withAccessPolicyName(String accessPolicyName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCacheAccessPolicyAssignmentProperties();
        }
        this.innerProperties().withAccessPolicyName(accessPolicyName);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
