// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.privatedns.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The resolution policy on the virtual network link. Only applicable for virtual network links to privatelink zones,
 * and for A,AAAA,CNAME queries. When set to 'NxDomainRedirect', Azure DNS resolver falls back to public resolution if
 * private dns query resolution results in non-existent domain response.
 */
public final class ResolutionPolicy extends ExpandableStringEnum<ResolutionPolicy> {
    /**
     * Static value Default for ResolutionPolicy.
     */
    public static final ResolutionPolicy DEFAULT = fromString("Default");

    /**
     * Static value NxDomainRedirect for ResolutionPolicy.
     */
    public static final ResolutionPolicy NX_DOMAIN_REDIRECT = fromString("NxDomainRedirect");

    /**
     * Creates a new instance of ResolutionPolicy value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ResolutionPolicy() {
    }

    /**
     * Creates or finds a ResolutionPolicy from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ResolutionPolicy.
     */
    public static ResolutionPolicy fromString(String name) {
        return fromString(name, ResolutionPolicy.class);
    }

    /**
     * Gets known ResolutionPolicy values.
     * 
     * @return known ResolutionPolicy values.
     */
    public static Collection<ResolutionPolicy> values() {
        return values(ResolutionPolicy.class);
    }
}
