// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.privatedns.models;

/**
 * Defines values for RecordType.
 */
public enum RecordType {
    /**
     * Enum value A.
     */
    A("A"),

    /**
     * Enum value AAAA.
     */
    AAAA("AAAA"),

    /**
     * Enum value CNAME.
     */
    CNAME("CNAME"),

    /**
     * Enum value MX.
     */
    MX("MX"),

    /**
     * Enum value PTR.
     */
    PTR("PTR"),

    /**
     * Enum value SOA.
     */
    SOA("SOA"),

    /**
     * Enum value SRV.
     */
    SRV("SRV"),

    /**
     * Enum value TXT.
     */
    TXT("TXT");

    /**
     * The actual serialized value for a RecordType instance.
     */
    private final String value;

    RecordType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a RecordType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed RecordType object, or null if unable to parse.
     */
    public static RecordType fromString(String value) {
        if (value == null) {
            return null;
        }
        RecordType[] items = RecordType.values();
        for (RecordType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
