// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.privatedns.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.privatedns.fluent.models.VirtualNetworkLinkInner;
import java.io.IOException;
import java.util.List;

/**
 * The response to a list virtual network link to Private DNS zone operation.
 */
@Fluent
public final class VirtualNetworkLinkListResult implements JsonSerializable<VirtualNetworkLinkListResult> {
    /*
     * Information about the virtual network links to the Private DNS zones.
     */
    private List<VirtualNetworkLinkInner> value;

    /*
     * The continuation token for the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualNetworkLinkListResult class.
     */
    public VirtualNetworkLinkListResult() {
    }

    /**
     * Get the value property: Information about the virtual network links to the Private DNS zones.
     * 
     * @return the value value.
     */
    public List<VirtualNetworkLinkInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Information about the virtual network links to the Private DNS zones.
     * 
     * @param value the value value to set.
     * @return the VirtualNetworkLinkListResult object itself.
     */
    public VirtualNetworkLinkListResult withValue(List<VirtualNetworkLinkInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The continuation token for the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkLinkListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkLinkListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkLinkListResult.
     */
    public static VirtualNetworkLinkListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkLinkListResult deserializedVirtualNetworkLinkListResult = new VirtualNetworkLinkListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualNetworkLinkInner> value
                        = reader.readArray(reader1 -> VirtualNetworkLinkInner.fromJson(reader1));
                    deserializedVirtualNetworkLinkListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualNetworkLinkListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkLinkListResult;
        });
    }
}
