// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.privatedns.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An AAAA record.
 */
@Fluent
public final class AaaaRecord implements JsonSerializable<AaaaRecord> {
    /*
     * The IPv6 address of this AAAA record.
     */
    private String ipv6Address;

    /**
     * Creates an instance of AaaaRecord class.
     */
    public AaaaRecord() {
    }

    /**
     * Get the ipv6Address property: The IPv6 address of this AAAA record.
     * 
     * @return the ipv6Address value.
     */
    public String ipv6Address() {
        return this.ipv6Address;
    }

    /**
     * Set the ipv6Address property: The IPv6 address of this AAAA record.
     * 
     * @param ipv6Address the ipv6Address value to set.
     * @return the AaaaRecord object itself.
     */
    public AaaaRecord withIpv6Address(String ipv6Address) {
        this.ipv6Address = ipv6Address;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipv6Address", this.ipv6Address);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AaaaRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AaaaRecord if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the AaaaRecord.
     */
    public static AaaaRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AaaaRecord deserializedAaaaRecord = new AaaaRecord();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipv6Address".equals(fieldName)) {
                    deserializedAaaaRecord.ipv6Address = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAaaaRecord;
        });
    }
}
