/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.privatedns.models.ProvisioningState;
import com.azure.resourcemanager.privatedns.models.VirtualNetworkLinkState;
import java.io.IOException;

public final class VirtualNetworkLinkProperties
implements JsonSerializable<VirtualNetworkLinkProperties> {
    private SubResource virtualNetwork;
    private Boolean registrationEnabled;
    private VirtualNetworkLinkState virtualNetworkLinkState;
    private ProvisioningState provisioningState;

    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    public VirtualNetworkLinkProperties withVirtualNetwork(SubResource virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public Boolean registrationEnabled() {
        return this.registrationEnabled;
    }

    public VirtualNetworkLinkProperties withRegistrationEnabled(Boolean registrationEnabled) {
        this.registrationEnabled = registrationEnabled;
        return this;
    }

    public VirtualNetworkLinkState virtualNetworkLinkState() {
        return this.virtualNetworkLinkState;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualNetwork", (JsonSerializable)this.virtualNetwork);
        jsonWriter.writeBooleanField("registrationEnabled", this.registrationEnabled);
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkLinkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkLinkProperties)jsonReader.readObject(reader -> {
            VirtualNetworkLinkProperties deserializedVirtualNetworkLinkProperties = new VirtualNetworkLinkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualNetwork".equals(fieldName)) {
                    deserializedVirtualNetworkLinkProperties.virtualNetwork = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("registrationEnabled".equals(fieldName)) {
                    deserializedVirtualNetworkLinkProperties.registrationEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("virtualNetworkLinkState".equals(fieldName)) {
                    deserializedVirtualNetworkLinkProperties.virtualNetworkLinkState = VirtualNetworkLinkState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualNetworkLinkProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkLinkProperties;
        });
    }
}

