/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.privatedns.fluent.models.VirtualNetworkLinkProperties;
import com.azure.resourcemanager.privatedns.models.ProvisioningState;
import com.azure.resourcemanager.privatedns.models.VirtualNetworkLinkState;
import java.io.IOException;
import java.util.Map;

public final class VirtualNetworkLinkInner
extends Resource {
    private String etag;
    private VirtualNetworkLinkProperties innerProperties;
    private String id;
    private String name;
    private String type;

    public String etag() {
        return this.etag;
    }

    public VirtualNetworkLinkInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    private VirtualNetworkLinkProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public VirtualNetworkLinkInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkLinkInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    public VirtualNetworkLinkInner withVirtualNetwork(SubResource virtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkLinkProperties();
        }
        this.innerProperties().withVirtualNetwork(virtualNetwork);
        return this;
    }

    public Boolean registrationEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().registrationEnabled();
    }

    public VirtualNetworkLinkInner withRegistrationEnabled(Boolean registrationEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkLinkProperties();
        }
        this.innerProperties().withRegistrationEnabled(registrationEnabled);
        return this;
    }

    public VirtualNetworkLinkState virtualNetworkLinkState() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkLinkState();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkLinkInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkLinkInner)((Object)jsonReader.readObject(reader -> {
            VirtualNetworkLinkInner deserializedVirtualNetworkLinkInner = new VirtualNetworkLinkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualNetworkLinkInner.withTags(tags);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.innerProperties = VirtualNetworkLinkProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkLinkInner;
        }));
    }
}

