/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VpnClientRootCertificatePropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class VpnClientRootCertificate
extends SubResource {
    private VpnClientRootCertificatePropertiesFormat innerProperties = new VpnClientRootCertificatePropertiesFormat();
    private String name;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(VpnClientRootCertificate.class);

    private VpnClientRootCertificatePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public VpnClientRootCertificate withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public VpnClientRootCertificate withId(String id) {
        super.withId(id);
        return this;
    }

    public String publicCertData() {
        return this.innerProperties() == null ? null : this.innerProperties().publicCertData();
    }

    public VpnClientRootCertificate withPublicCertData(String publicCertData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnClientRootCertificatePropertiesFormat();
        }
        this.innerProperties().withPublicCertData(publicCertData);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model VpnClientRootCertificate"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static VpnClientRootCertificate fromJson(JsonReader jsonReader) throws IOException {
        return (VpnClientRootCertificate)((Object)jsonReader.readObject(reader -> {
            VpnClientRootCertificate deserializedVpnClientRootCertificate = new VpnClientRootCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVpnClientRootCertificate.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVpnClientRootCertificate.innerProperties = VpnClientRootCertificatePropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVpnClientRootCertificate.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVpnClientRootCertificate.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnClientRootCertificate;
        }));
    }
}

