/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.PolicySettingsLogScrubbing;
import com.azure.resourcemanager.network.models.WebApplicationFirewallEnabledState;
import com.azure.resourcemanager.network.models.WebApplicationFirewallMode;
import java.io.IOException;

public final class PolicySettings
implements JsonSerializable<PolicySettings> {
    private WebApplicationFirewallEnabledState state;
    private WebApplicationFirewallMode mode;
    private Boolean requestBodyCheck;
    private Integer requestBodyInspectLimitInKB;
    private Boolean requestBodyEnforcement;
    private Integer maxRequestBodySizeInKb;
    private Boolean fileUploadEnforcement;
    private Integer fileUploadLimitInMb;
    private Integer customBlockResponseStatusCode;
    private String customBlockResponseBody;
    private PolicySettingsLogScrubbing logScrubbing;
    private Integer jsChallengeCookieExpirationInMins;

    public WebApplicationFirewallEnabledState state() {
        return this.state;
    }

    public PolicySettings withState(WebApplicationFirewallEnabledState state) {
        this.state = state;
        return this;
    }

    public WebApplicationFirewallMode mode() {
        return this.mode;
    }

    public PolicySettings withMode(WebApplicationFirewallMode mode) {
        this.mode = mode;
        return this;
    }

    public Boolean requestBodyCheck() {
        return this.requestBodyCheck;
    }

    public PolicySettings withRequestBodyCheck(Boolean requestBodyCheck) {
        this.requestBodyCheck = requestBodyCheck;
        return this;
    }

    public Integer requestBodyInspectLimitInKB() {
        return this.requestBodyInspectLimitInKB;
    }

    public PolicySettings withRequestBodyInspectLimitInKB(Integer requestBodyInspectLimitInKB) {
        this.requestBodyInspectLimitInKB = requestBodyInspectLimitInKB;
        return this;
    }

    public Boolean requestBodyEnforcement() {
        return this.requestBodyEnforcement;
    }

    public PolicySettings withRequestBodyEnforcement(Boolean requestBodyEnforcement) {
        this.requestBodyEnforcement = requestBodyEnforcement;
        return this;
    }

    public Integer maxRequestBodySizeInKb() {
        return this.maxRequestBodySizeInKb;
    }

    public PolicySettings withMaxRequestBodySizeInKb(Integer maxRequestBodySizeInKb) {
        this.maxRequestBodySizeInKb = maxRequestBodySizeInKb;
        return this;
    }

    public Boolean fileUploadEnforcement() {
        return this.fileUploadEnforcement;
    }

    public PolicySettings withFileUploadEnforcement(Boolean fileUploadEnforcement) {
        this.fileUploadEnforcement = fileUploadEnforcement;
        return this;
    }

    public Integer fileUploadLimitInMb() {
        return this.fileUploadLimitInMb;
    }

    public PolicySettings withFileUploadLimitInMb(Integer fileUploadLimitInMb) {
        this.fileUploadLimitInMb = fileUploadLimitInMb;
        return this;
    }

    public Integer customBlockResponseStatusCode() {
        return this.customBlockResponseStatusCode;
    }

    public PolicySettings withCustomBlockResponseStatusCode(Integer customBlockResponseStatusCode) {
        this.customBlockResponseStatusCode = customBlockResponseStatusCode;
        return this;
    }

    public String customBlockResponseBody() {
        return this.customBlockResponseBody;
    }

    public PolicySettings withCustomBlockResponseBody(String customBlockResponseBody) {
        this.customBlockResponseBody = customBlockResponseBody;
        return this;
    }

    public PolicySettingsLogScrubbing logScrubbing() {
        return this.logScrubbing;
    }

    public PolicySettings withLogScrubbing(PolicySettingsLogScrubbing logScrubbing) {
        this.logScrubbing = logScrubbing;
        return this;
    }

    public Integer jsChallengeCookieExpirationInMins() {
        return this.jsChallengeCookieExpirationInMins;
    }

    public PolicySettings withJsChallengeCookieExpirationInMins(Integer jsChallengeCookieExpirationInMins) {
        this.jsChallengeCookieExpirationInMins = jsChallengeCookieExpirationInMins;
        return this;
    }

    public void validate() {
        if (this.logScrubbing() != null) {
            this.logScrubbing().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeBooleanField("requestBodyCheck", this.requestBodyCheck);
        jsonWriter.writeNumberField("requestBodyInspectLimitInKB", (Number)this.requestBodyInspectLimitInKB);
        jsonWriter.writeBooleanField("requestBodyEnforcement", this.requestBodyEnforcement);
        jsonWriter.writeNumberField("maxRequestBodySizeInKb", (Number)this.maxRequestBodySizeInKb);
        jsonWriter.writeBooleanField("fileUploadEnforcement", this.fileUploadEnforcement);
        jsonWriter.writeNumberField("fileUploadLimitInMb", (Number)this.fileUploadLimitInMb);
        jsonWriter.writeNumberField("customBlockResponseStatusCode", (Number)this.customBlockResponseStatusCode);
        jsonWriter.writeStringField("customBlockResponseBody", this.customBlockResponseBody);
        jsonWriter.writeJsonField("logScrubbing", (JsonSerializable)this.logScrubbing);
        jsonWriter.writeNumberField("jsChallengeCookieExpirationInMins", (Number)this.jsChallengeCookieExpirationInMins);
        return jsonWriter.writeEndObject();
    }

    public static PolicySettings fromJson(JsonReader jsonReader) throws IOException {
        return (PolicySettings)jsonReader.readObject(reader -> {
            PolicySettings deserializedPolicySettings = new PolicySettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedPolicySettings.state = WebApplicationFirewallEnabledState.fromString(reader.getString());
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedPolicySettings.mode = WebApplicationFirewallMode.fromString(reader.getString());
                    continue;
                }
                if ("requestBodyCheck".equals(fieldName)) {
                    deserializedPolicySettings.requestBodyCheck = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("requestBodyInspectLimitInKB".equals(fieldName)) {
                    deserializedPolicySettings.requestBodyInspectLimitInKB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("requestBodyEnforcement".equals(fieldName)) {
                    deserializedPolicySettings.requestBodyEnforcement = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxRequestBodySizeInKb".equals(fieldName)) {
                    deserializedPolicySettings.maxRequestBodySizeInKb = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fileUploadEnforcement".equals(fieldName)) {
                    deserializedPolicySettings.fileUploadEnforcement = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("fileUploadLimitInMb".equals(fieldName)) {
                    deserializedPolicySettings.fileUploadLimitInMb = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("customBlockResponseStatusCode".equals(fieldName)) {
                    deserializedPolicySettings.customBlockResponseStatusCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("customBlockResponseBody".equals(fieldName)) {
                    deserializedPolicySettings.customBlockResponseBody = reader.getString();
                    continue;
                }
                if ("logScrubbing".equals(fieldName)) {
                    deserializedPolicySettings.logScrubbing = PolicySettingsLogScrubbing.fromJson(reader);
                    continue;
                }
                if ("jsChallengeCookieExpirationInMins".equals(fieldName)) {
                    deserializedPolicySettings.jsChallengeCookieExpirationInMins = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicySettings;
        });
    }
}

