/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.DdosDetectionRulePropertiesFormat;
import com.azure.resourcemanager.network.models.DdosDetectionMode;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TrafficDetectionRule;
import java.io.IOException;

public final class DdosDetectionRule
extends SubResource {
    private String name;
    private String etag;
    private String type;
    private DdosDetectionRulePropertiesFormat innerProperties;

    public String name() {
        return this.name;
    }

    public DdosDetectionRule withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    private DdosDetectionRulePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public DdosDetectionRule withId(String id) {
        super.withId(id);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public DdosDetectionMode detectionMode() {
        return this.innerProperties() == null ? null : this.innerProperties().detectionMode();
    }

    public DdosDetectionRule withDetectionMode(DdosDetectionMode detectionMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DdosDetectionRulePropertiesFormat();
        }
        this.innerProperties().withDetectionMode(detectionMode);
        return this;
    }

    public TrafficDetectionRule trafficDetectionRule() {
        return this.innerProperties() == null ? null : this.innerProperties().trafficDetectionRule();
    }

    public DdosDetectionRule withTrafficDetectionRule(TrafficDetectionRule trafficDetectionRule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DdosDetectionRulePropertiesFormat();
        }
        this.innerProperties().withTrafficDetectionRule(trafficDetectionRule);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DdosDetectionRule fromJson(JsonReader jsonReader) throws IOException {
        return (DdosDetectionRule)((Object)jsonReader.readObject(reader -> {
            DdosDetectionRule deserializedDdosDetectionRule = new DdosDetectionRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDdosDetectionRule.withId(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDdosDetectionRule.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDdosDetectionRule.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDdosDetectionRule.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDdosDetectionRule.innerProperties = DdosDetectionRulePropertiesFormat.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDdosDetectionRule;
        }));
    }
}

