/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayRewriteRuleActionSet;
import com.azure.resourcemanager.network.models.ApplicationGatewayRewriteRuleCondition;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayRewriteRule
implements JsonSerializable<ApplicationGatewayRewriteRule> {
    private String name;
    private Integer ruleSequence;
    private List<ApplicationGatewayRewriteRuleCondition> conditions;
    private ApplicationGatewayRewriteRuleActionSet actionSet;

    public String name() {
        return this.name;
    }

    public ApplicationGatewayRewriteRule withName(String name) {
        this.name = name;
        return this;
    }

    public Integer ruleSequence() {
        return this.ruleSequence;
    }

    public ApplicationGatewayRewriteRule withRuleSequence(Integer ruleSequence) {
        this.ruleSequence = ruleSequence;
        return this;
    }

    public List<ApplicationGatewayRewriteRuleCondition> conditions() {
        return this.conditions;
    }

    public ApplicationGatewayRewriteRule withConditions(List<ApplicationGatewayRewriteRuleCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public ApplicationGatewayRewriteRuleActionSet actionSet() {
        return this.actionSet;
    }

    public ApplicationGatewayRewriteRule withActionSet(ApplicationGatewayRewriteRuleActionSet actionSet) {
        this.actionSet = actionSet;
        return this;
    }

    public void validate() {
        if (this.conditions() != null) {
            this.conditions().forEach(e -> e.validate());
        }
        if (this.actionSet() != null) {
            this.actionSet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("ruleSequence", (Number)this.ruleSequence);
        jsonWriter.writeArrayField("conditions", this.conditions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("actionSet", (JsonSerializable)this.actionSet);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayRewriteRule fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayRewriteRule)jsonReader.readObject(reader -> {
            ApplicationGatewayRewriteRule deserializedApplicationGatewayRewriteRule = new ApplicationGatewayRewriteRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRule.name = reader.getString();
                    continue;
                }
                if ("ruleSequence".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRule.ruleSequence = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("conditions".equals(fieldName)) {
                    List conditions;
                    deserializedApplicationGatewayRewriteRule.conditions = conditions = reader.readArray(reader1 -> ApplicationGatewayRewriteRuleCondition.fromJson(reader1));
                    continue;
                }
                if ("actionSet".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRule.actionSet = ApplicationGatewayRewriteRuleActionSet.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayRewriteRule;
        });
    }
}

