/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayClientAuthVerificationModes;
import com.azure.resourcemanager.network.models.ApplicationGatewayClientRevocationOptions;
import java.io.IOException;

public final class ApplicationGatewayClientAuthConfiguration
implements JsonSerializable<ApplicationGatewayClientAuthConfiguration> {
    private Boolean verifyClientCertIssuerDN;
    private ApplicationGatewayClientRevocationOptions verifyClientRevocation;
    private ApplicationGatewayClientAuthVerificationModes verifyClientAuthMode;

    public Boolean verifyClientCertIssuerDN() {
        return this.verifyClientCertIssuerDN;
    }

    public ApplicationGatewayClientAuthConfiguration withVerifyClientCertIssuerDN(Boolean verifyClientCertIssuerDN) {
        this.verifyClientCertIssuerDN = verifyClientCertIssuerDN;
        return this;
    }

    public ApplicationGatewayClientRevocationOptions verifyClientRevocation() {
        return this.verifyClientRevocation;
    }

    public ApplicationGatewayClientAuthConfiguration withVerifyClientRevocation(ApplicationGatewayClientRevocationOptions verifyClientRevocation) {
        this.verifyClientRevocation = verifyClientRevocation;
        return this;
    }

    public ApplicationGatewayClientAuthVerificationModes verifyClientAuthMode() {
        return this.verifyClientAuthMode;
    }

    public ApplicationGatewayClientAuthConfiguration withVerifyClientAuthMode(ApplicationGatewayClientAuthVerificationModes verifyClientAuthMode) {
        this.verifyClientAuthMode = verifyClientAuthMode;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("verifyClientCertIssuerDN", this.verifyClientCertIssuerDN);
        jsonWriter.writeStringField("verifyClientRevocation", this.verifyClientRevocation == null ? null : this.verifyClientRevocation.toString());
        jsonWriter.writeStringField("verifyClientAuthMode", this.verifyClientAuthMode == null ? null : this.verifyClientAuthMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayClientAuthConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayClientAuthConfiguration)jsonReader.readObject(reader -> {
            ApplicationGatewayClientAuthConfiguration deserializedApplicationGatewayClientAuthConfiguration = new ApplicationGatewayClientAuthConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("verifyClientCertIssuerDN".equals(fieldName)) {
                    deserializedApplicationGatewayClientAuthConfiguration.verifyClientCertIssuerDN = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("verifyClientRevocation".equals(fieldName)) {
                    deserializedApplicationGatewayClientAuthConfiguration.verifyClientRevocation = ApplicationGatewayClientRevocationOptions.fromString(reader.getString());
                    continue;
                }
                if ("verifyClientAuthMode".equals(fieldName)) {
                    deserializedApplicationGatewayClientAuthConfiguration.verifyClientAuthMode = ApplicationGatewayClientAuthVerificationModes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayClientAuthConfiguration;
        });
    }
}

