/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.NetworkSecurityPerimeterAccessRulesClient;
import com.azure.resourcemanager.network.fluent.models.NspAccessRuleInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.NspAccessRuleListResult;
import reactor.core.publisher.Mono;

public final class NetworkSecurityPerimeterAccessRulesClientImpl
implements NetworkSecurityPerimeterAccessRulesClient {
    private final NetworkSecurityPerimeterAccessRulesService service;
    private final NetworkManagementClientImpl client;

    NetworkSecurityPerimeterAccessRulesClientImpl(NetworkManagementClientImpl client) {
        this.service = (NetworkSecurityPerimeterAccessRulesService)RestProxy.create(NetworkSecurityPerimeterAccessRulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NspAccessRuleInner>> getWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, "2025-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NspAccessRuleInner>> getWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, "2025-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NspAccessRuleInner> getAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName) {
        return this.getWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NspAccessRuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NspAccessRuleInner> getWithResponse(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NspAccessRuleInner get(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName) {
        return (NspAccessRuleInner)((Object)this.getWithResponse(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NspAccessRuleInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, NspAccessRuleInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, "2025-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NspAccessRuleInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, NspAccessRuleInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, "2025-03-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NspAccessRuleInner> createOrUpdateAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, NspAccessRuleInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NspAccessRuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NspAccessRuleInner> createOrUpdateWithResponse(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, NspAccessRuleInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NspAccessRuleInner createOrUpdate(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, NspAccessRuleInner parameters) {
        return (NspAccessRuleInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, "2025-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, "2025-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName) {
        return this.deleteWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName) {
        this.deleteWithResponse(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NspAccessRuleInner>> listSinglePageAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, profileName, "2025-03-01", top, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NspAccessRuleListResult)res.getValue()).value(), ((NspAccessRuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NspAccessRuleInner>> listSinglePageAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, Integer top, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, profileName, "2025-03-01", top, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NspAccessRuleListResult)res.getValue()).value(), ((NspAccessRuleListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NspAccessRuleInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, Integer top, String skipToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkSecurityPerimeterName, profileName, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NspAccessRuleInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName) {
        Integer top = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkSecurityPerimeterName, profileName, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NspAccessRuleInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, Integer top, String skipToken, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkSecurityPerimeterName, profileName, top, skipToken, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NspAccessRuleInner> list(String resourceGroupName, String networkSecurityPerimeterName, String profileName) {
        Integer top = null;
        String skipToken = null;
        return new PagedIterable(this.listAsync(resourceGroupName, networkSecurityPerimeterName, profileName, top, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NspAccessRuleInner> list(String resourceGroupName, String networkSecurityPerimeterName, String profileName, Integer top, String skipToken, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkSecurityPerimeterName, profileName, top, skipToken, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> reconcileWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, Object parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.reconcile(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, "2025-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Object>> reconcileWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, Object parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.reconcile(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, "2025-03-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> reconcileAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, Object parameters) {
        return this.reconcileWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, parameters).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> reconcileWithResponse(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, Object parameters, Context context) {
        return (Response)this.reconcileWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object reconcile(String resourceGroupName, String networkSecurityPerimeterName, String profileName, String accessRuleName, Object parameters) {
        return this.reconcileWithResponse(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NspAccessRuleInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NspAccessRuleListResult)res.getValue()).value(), ((NspAccessRuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NspAccessRuleInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NspAccessRuleListResult)res.getValue()).value(), ((NspAccessRuleListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementClientNetworkSecurityPerimeterAccessRules")
    public static interface NetworkSecurityPerimeterAccessRulesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules/{accessRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NspAccessRuleInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkSecurityPerimeterName") String var4, @PathParam(value="profileName") String var5, @PathParam(value="accessRuleName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules/{accessRuleName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NspAccessRuleInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkSecurityPerimeterName") String var4, @PathParam(value="profileName") String var5, @PathParam(value="accessRuleName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") NspAccessRuleInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules/{accessRuleName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkSecurityPerimeterName") String var4, @PathParam(value="profileName") String var5, @PathParam(value="accessRuleName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NspAccessRuleListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkSecurityPerimeterName") String var4, @PathParam(value="profileName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$skipToken") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules/{accessRuleName}/reconcile")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Object>> reconcile(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkSecurityPerimeterName") String var4, @PathParam(value="profileName") String var5, @PathParam(value="accessRuleName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") Object var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NspAccessRuleListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

