/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FlowLogFormatParameters;
import com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import java.io.IOException;

public final class FlowLogProperties
implements JsonSerializable<FlowLogProperties> {
    private String storageId;
    private String enabledFilteringCriteria;
    private String recordTypes;
    private boolean enabled;
    private RetentionPolicyParameters retentionPolicy;
    private FlowLogFormatParameters format;
    private static final ClientLogger LOGGER = new ClientLogger(FlowLogProperties.class);

    public String storageId() {
        return this.storageId;
    }

    public FlowLogProperties withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    public String enabledFilteringCriteria() {
        return this.enabledFilteringCriteria;
    }

    public FlowLogProperties withEnabledFilteringCriteria(String enabledFilteringCriteria) {
        this.enabledFilteringCriteria = enabledFilteringCriteria;
        return this;
    }

    public String recordTypes() {
        return this.recordTypes;
    }

    public FlowLogProperties withRecordTypes(String recordTypes) {
        this.recordTypes = recordTypes;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public FlowLogProperties withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public RetentionPolicyParameters retentionPolicy() {
        return this.retentionPolicy;
    }

    public FlowLogProperties withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public FlowLogFormatParameters format() {
        return this.format;
    }

    public FlowLogProperties withFormat(FlowLogFormatParameters format) {
        this.format = format;
        return this;
    }

    public void validate() {
        if (this.storageId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageId in model FlowLogProperties"));
        }
        if (this.retentionPolicy() != null) {
            this.retentionPolicy().validate();
        }
        if (this.format() != null) {
            this.format().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageId", this.storageId);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("enabledFilteringCriteria", this.enabledFilteringCriteria);
        jsonWriter.writeStringField("recordTypes", this.recordTypes);
        jsonWriter.writeJsonField("retentionPolicy", (JsonSerializable)this.retentionPolicy);
        jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
        return jsonWriter.writeEndObject();
    }

    public static FlowLogProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FlowLogProperties)jsonReader.readObject(reader -> {
            FlowLogProperties deserializedFlowLogProperties = new FlowLogProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageId".equals(fieldName)) {
                    deserializedFlowLogProperties.storageId = reader.getString();
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedFlowLogProperties.enabled = reader.getBoolean();
                    continue;
                }
                if ("enabledFilteringCriteria".equals(fieldName)) {
                    deserializedFlowLogProperties.enabledFilteringCriteria = reader.getString();
                    continue;
                }
                if ("recordTypes".equals(fieldName)) {
                    deserializedFlowLogProperties.recordTypes = reader.getString();
                    continue;
                }
                if ("retentionPolicy".equals(fieldName)) {
                    deserializedFlowLogProperties.retentionPolicy = RetentionPolicyParameters.fromJson(reader);
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedFlowLogProperties.format = FlowLogFormatParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlowLogProperties;
        });
    }
}

