/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.DdosDetectionRule;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class DdosCustomPolicyPropertiesFormat
implements JsonSerializable<DdosCustomPolicyPropertiesFormat> {
    private String resourceGuid;
    private ProvisioningState provisioningState;
    private List<DdosDetectionRule> detectionRules;
    private List<SubResource> frontEndIpConfiguration;

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<DdosDetectionRule> detectionRules() {
        return this.detectionRules;
    }

    public DdosCustomPolicyPropertiesFormat withDetectionRules(List<DdosDetectionRule> detectionRules) {
        this.detectionRules = detectionRules;
        return this;
    }

    public List<SubResource> frontEndIpConfiguration() {
        return this.frontEndIpConfiguration;
    }

    public DdosCustomPolicyPropertiesFormat withFrontEndIpConfiguration(List<SubResource> frontEndIpConfiguration) {
        this.frontEndIpConfiguration = frontEndIpConfiguration;
        return this;
    }

    public void validate() {
        if (this.detectionRules() != null) {
            this.detectionRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("detectionRules", this.detectionRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("frontEndIpConfiguration", this.frontEndIpConfiguration, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DdosCustomPolicyPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (DdosCustomPolicyPropertiesFormat)jsonReader.readObject(reader -> {
            DdosCustomPolicyPropertiesFormat deserializedDdosCustomPolicyPropertiesFormat = new DdosCustomPolicyPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceGuid".equals(fieldName)) {
                    deserializedDdosCustomPolicyPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDdosCustomPolicyPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("detectionRules".equals(fieldName)) {
                    List detectionRules;
                    deserializedDdosCustomPolicyPropertiesFormat.detectionRules = detectionRules = reader.readArray(reader1 -> DdosDetectionRule.fromJson(reader1));
                    continue;
                }
                if ("frontEndIpConfiguration".equals(fieldName)) {
                    List frontEndIpConfiguration;
                    deserializedDdosCustomPolicyPropertiesFormat.frontEndIpConfiguration = frontEndIpConfiguration = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDdosCustomPolicyPropertiesFormat;
        });
    }
}

