/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConnectionStatus;
import com.azure.resourcemanager.network.models.ConnectivityHop;
import java.io.IOException;
import java.util.List;

public final class ConnectivityInformationInner
implements JsonSerializable<ConnectivityInformationInner> {
    private List<ConnectivityHop> hops;
    private ConnectionStatus connectionStatus;
    private Integer avgLatencyInMs;
    private Integer minLatencyInMs;
    private Integer maxLatencyInMs;
    private Integer probesSent;
    private Integer probesFailed;

    public List<ConnectivityHop> hops() {
        return this.hops;
    }

    public ConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public Integer avgLatencyInMs() {
        return this.avgLatencyInMs;
    }

    public Integer minLatencyInMs() {
        return this.minLatencyInMs;
    }

    public Integer maxLatencyInMs() {
        return this.maxLatencyInMs;
    }

    public Integer probesSent() {
        return this.probesSent;
    }

    public Integer probesFailed() {
        return this.probesFailed;
    }

    public void validate() {
        if (this.hops() != null) {
            this.hops().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivityInformationInner)jsonReader.readObject(reader -> {
            ConnectivityInformationInner deserializedConnectivityInformationInner = new ConnectivityInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hops".equals(fieldName)) {
                    List hops;
                    deserializedConnectivityInformationInner.hops = hops = reader.readArray(reader1 -> ConnectivityHop.fromJson(reader1));
                    continue;
                }
                if ("connectionStatus".equals(fieldName)) {
                    deserializedConnectivityInformationInner.connectionStatus = ConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("avgLatencyInMs".equals(fieldName)) {
                    deserializedConnectivityInformationInner.avgLatencyInMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minLatencyInMs".equals(fieldName)) {
                    deserializedConnectivityInformationInner.minLatencyInMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxLatencyInMs".equals(fieldName)) {
                    deserializedConnectivityInformationInner.maxLatencyInMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("probesSent".equals(fieldName)) {
                    deserializedConnectivityInformationInner.probesSent = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("probesFailed".equals(fieldName)) {
                    deserializedConnectivityInformationInner.probesFailed = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityInformationInner;
        });
    }
}

