/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.DdosTrafficType;
import java.io.IOException;

public final class TrafficDetectionRule
implements JsonSerializable<TrafficDetectionRule> {
    private DdosTrafficType trafficType;
    private Integer packetsPerSecond;

    public DdosTrafficType trafficType() {
        return this.trafficType;
    }

    public TrafficDetectionRule withTrafficType(DdosTrafficType trafficType) {
        this.trafficType = trafficType;
        return this;
    }

    public Integer packetsPerSecond() {
        return this.packetsPerSecond;
    }

    public TrafficDetectionRule withPacketsPerSecond(Integer packetsPerSecond) {
        this.packetsPerSecond = packetsPerSecond;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("trafficType", this.trafficType == null ? null : this.trafficType.toString());
        jsonWriter.writeNumberField("packetsPerSecond", (Number)this.packetsPerSecond);
        return jsonWriter.writeEndObject();
    }

    public static TrafficDetectionRule fromJson(JsonReader jsonReader) throws IOException {
        return (TrafficDetectionRule)jsonReader.readObject(reader -> {
            TrafficDetectionRule deserializedTrafficDetectionRule = new TrafficDetectionRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("trafficType".equals(fieldName)) {
                    deserializedTrafficDetectionRule.trafficType = DdosTrafficType.fromString(reader.getString());
                    continue;
                }
                if ("packetsPerSecond".equals(fieldName)) {
                    deserializedTrafficDetectionRule.packetsPerSecond = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrafficDetectionRule;
        });
    }
}

