/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.TopologyAssociation;
import java.io.IOException;
import java.util.List;

public final class TopologyResource
implements JsonSerializable<TopologyResource> {
    private String name;
    private String id;
    private String location;
    private List<TopologyAssociation> associations;

    public String name() {
        return this.name;
    }

    public TopologyResource withName(String name) {
        this.name = name;
        return this;
    }

    public String id() {
        return this.id;
    }

    public TopologyResource withId(String id) {
        this.id = id;
        return this;
    }

    public String location() {
        return this.location;
    }

    public TopologyResource withLocation(String location) {
        this.location = location;
        return this;
    }

    public List<TopologyAssociation> associations() {
        return this.associations;
    }

    public TopologyResource withAssociations(List<TopologyAssociation> associations) {
        this.associations = associations;
        return this;
    }

    public void validate() {
        if (this.associations() != null) {
            this.associations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeArrayField("associations", this.associations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TopologyResource fromJson(JsonReader jsonReader) throws IOException {
        return (TopologyResource)jsonReader.readObject(reader -> {
            TopologyResource deserializedTopologyResource = new TopologyResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTopologyResource.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedTopologyResource.id = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTopologyResource.location = reader.getString();
                    continue;
                }
                if ("associations".equals(fieldName)) {
                    List associations;
                    deserializedTopologyResource.associations = associations = reader.readArray(reader1 -> TopologyAssociation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopologyResource;
        });
    }
}

