/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NvaInVnetSubnetReferenceProperties;
import com.azure.resourcemanager.network.models.NvaNicType;
import java.io.IOException;
import java.util.List;

public final class NvaInterfaceConfigurationsProperties
implements JsonSerializable<NvaInterfaceConfigurationsProperties> {
    private NvaInVnetSubnetReferenceProperties subnet;
    private List<NvaNicType> type;
    private String name;

    public NvaInVnetSubnetReferenceProperties subnet() {
        return this.subnet;
    }

    public NvaInterfaceConfigurationsProperties withSubnet(NvaInVnetSubnetReferenceProperties subnet) {
        this.subnet = subnet;
        return this;
    }

    public List<NvaNicType> type() {
        return this.type;
    }

    public NvaInterfaceConfigurationsProperties withType(List<NvaNicType> type) {
        this.type = type;
        return this;
    }

    public String name() {
        return this.name;
    }

    public NvaInterfaceConfigurationsProperties withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeArrayField("type", this.type, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static NvaInterfaceConfigurationsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NvaInterfaceConfigurationsProperties)jsonReader.readObject(reader -> {
            NvaInterfaceConfigurationsProperties deserializedNvaInterfaceConfigurationsProperties = new NvaInterfaceConfigurationsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnet".equals(fieldName)) {
                    deserializedNvaInterfaceConfigurationsProperties.subnet = NvaInVnetSubnetReferenceProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    List type;
                    deserializedNvaInterfaceConfigurationsProperties.type = type = reader.readArray(reader1 -> NvaNicType.fromString(reader1.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNvaInterfaceConfigurationsProperties.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNvaInterfaceConfigurationsProperties;
        });
    }
}

