/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.paging.PageRetriever;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;

final class PagedConverterForMergedPagedFlux {
    private PagedConverterForMergedPagedFlux() {
    }

    static <T, S> PagedFlux<S> mapPage(PagedFlux<T> pagedFlux, Function<T, S> mapper) {
        Supplier<PageRetriever> provider = () -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFlux.byPage() : pagedFlux.byPage(continuationToken);
            return flux.map(PagedConverterForMergedPagedFlux.mapPagedResponse(mapper));
        };
        return PagedFlux.create(provider);
    }

    private static <T, S> Function<PagedResponse<T>, PagedResponse<S>> mapPagedResponse(Function<T, S> mapper) {
        return pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(mapper).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null);
    }
}

