/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.NetworkSecurityPerimetersClient;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityPerimeterInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.NetworkSecurityPerimeterListResult;
import com.azure.resourcemanager.network.models.UpdateTagsRequest;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NetworkSecurityPerimetersClientImpl
implements InnerSupportsGet<NetworkSecurityPerimeterInner>,
InnerSupportsListing<NetworkSecurityPerimeterInner>,
InnerSupportsDelete<Void>,
NetworkSecurityPerimetersClient {
    private final NetworkSecurityPerimetersService service;
    private final NetworkManagementClientImpl client;

    NetworkSecurityPerimetersClientImpl(NetworkManagementClientImpl client) {
        this.service = (NetworkSecurityPerimetersService)RestProxy.create(NetworkSecurityPerimetersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NetworkSecurityPerimeterInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, "2025-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkSecurityPerimeterInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, "2025-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkSecurityPerimeterInner> getByResourceGroupAsync(String resourceGroupName, String networkSecurityPerimeterName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, networkSecurityPerimeterName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NetworkSecurityPerimeterInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkSecurityPerimeterInner> getByResourceGroupWithResponse(String resourceGroupName, String networkSecurityPerimeterName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkSecurityPerimeterInner getByResourceGroup(String resourceGroupName, String networkSecurityPerimeterName) {
        return (NetworkSecurityPerimeterInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, networkSecurityPerimeterName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NetworkSecurityPerimeterInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, NetworkSecurityPerimeterInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, "2025-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkSecurityPerimeterInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, NetworkSecurityPerimeterInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, "2025-03-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkSecurityPerimeterInner> createOrUpdateAsync(String resourceGroupName, String networkSecurityPerimeterName, NetworkSecurityPerimeterInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NetworkSecurityPerimeterInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkSecurityPerimeterInner> createOrUpdateWithResponse(String resourceGroupName, String networkSecurityPerimeterName, NetworkSecurityPerimeterInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkSecurityPerimeterInner createOrUpdate(String resourceGroupName, String networkSecurityPerimeterName, NetworkSecurityPerimeterInner parameters) {
        return (NetworkSecurityPerimeterInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, networkSecurityPerimeterName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, Boolean forceDeletion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, "2025-03-01", forceDeletion, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, Boolean forceDeletion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, "2025-03-01", forceDeletion, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkSecurityPerimeterName, Boolean forceDeletion) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, forceDeletion);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkSecurityPerimeterName) {
        Boolean forceDeletion = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, forceDeletion);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkSecurityPerimeterName, Boolean forceDeletion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, forceDeletion, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkSecurityPerimeterName) {
        Boolean forceDeletion = null;
        return this.beginDeleteAsync(resourceGroupName, networkSecurityPerimeterName, forceDeletion).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkSecurityPerimeterName, Boolean forceDeletion, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkSecurityPerimeterName, forceDeletion, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkSecurityPerimeterName, Boolean forceDeletion) {
        return this.beginDeleteAsync(resourceGroupName, networkSecurityPerimeterName, forceDeletion).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkSecurityPerimeterName) {
        Boolean forceDeletion = null;
        return this.beginDeleteAsync(resourceGroupName, networkSecurityPerimeterName, forceDeletion).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String networkSecurityPerimeterName, Boolean forceDeletion, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkSecurityPerimeterName, forceDeletion, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkSecurityPerimeterName) {
        Boolean forceDeletion = null;
        this.deleteAsync(resourceGroupName, networkSecurityPerimeterName, forceDeletion).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkSecurityPerimeterName, Boolean forceDeletion, Context context) {
        this.deleteAsync(resourceGroupName, networkSecurityPerimeterName, forceDeletion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NetworkSecurityPerimeterInner>> patchWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, UpdateTagsRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.patch(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, "2025-03-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkSecurityPerimeterInner>> patchWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName, UpdateTagsRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.patch(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkSecurityPerimeterName, "2025-03-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkSecurityPerimeterInner> patchAsync(String resourceGroupName, String networkSecurityPerimeterName, UpdateTagsRequest parameters) {
        return this.patchWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NetworkSecurityPerimeterInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkSecurityPerimeterInner> patchWithResponse(String resourceGroupName, String networkSecurityPerimeterName, UpdateTagsRequest parameters, Context context) {
        return (Response)this.patchWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkSecurityPerimeterInner patch(String resourceGroupName, String networkSecurityPerimeterName, UpdateTagsRequest parameters) {
        return (NetworkSecurityPerimeterInner)((Object)this.patchWithResponse(resourceGroupName, networkSecurityPerimeterName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterInner>> listSinglePageAsync(Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2025-03-01", top, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterListResult)res.getValue()).value(), ((NetworkSecurityPerimeterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterInner>> listSinglePageAsync(Integer top, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2025-03-01", top, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterListResult)res.getValue()).value(), ((NetworkSecurityPerimeterListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NetworkSecurityPerimeterInner> listAsync(Integer top, String skipToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(top, skipToken), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NetworkSecurityPerimeterInner> listAsync() {
        Integer top = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(top, skipToken), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NetworkSecurityPerimeterInner> listAsync(Integer top, String skipToken, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(top, skipToken, context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkSecurityPerimeterInner> list() {
        Integer top = null;
        String skipToken = null;
        return new PagedIterable(this.listAsync(top, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkSecurityPerimeterInner> list(Integer top, String skipToken, Context context) {
        return new PagedIterable(this.listAsync(top, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2025-03-01", top, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterListResult)res.getValue()).value(), ((NetworkSecurityPerimeterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2025-03-01", top, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterListResult)res.getValue()).value(), ((NetworkSecurityPerimeterListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NetworkSecurityPerimeterInner> listByResourceGroupAsync(String resourceGroupName, Integer top, String skipToken) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NetworkSecurityPerimeterInner> listByResourceGroupAsync(String resourceGroupName) {
        Integer top = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NetworkSecurityPerimeterInner> listByResourceGroupAsync(String resourceGroupName, Integer top, String skipToken, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top, skipToken, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkSecurityPerimeterInner> listByResourceGroup(String resourceGroupName) {
        Integer top = null;
        String skipToken = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, top, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NetworkSecurityPerimeterInner> listByResourceGroup(String resourceGroupName, Integer top, String skipToken, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, top, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterListResult)res.getValue()).value(), ((NetworkSecurityPerimeterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterListResult)res.getValue()).value(), ((NetworkSecurityPerimeterListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterListResult)res.getValue()).value(), ((NetworkSecurityPerimeterListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkSecurityPerimeterListResult)res.getValue()).value(), ((NetworkSecurityPerimeterListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementClientNetworkSecurityPerimeters")
    public static interface NetworkSecurityPerimetersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkSecurityPerimeterName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkSecurityPerimeterName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") NetworkSecurityPerimeterInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkSecurityPerimeterName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="forceDeletion") Boolean var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterInner>> patch(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkSecurityPerimeterName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") UpdateTagsRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/networkSecurityPerimeters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$skipToken") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$skipToken") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkSecurityPerimeterListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

