/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.FirewallPolicyRuleCollectionGroupDraftsClient;
import com.azure.resourcemanager.network.fluent.models.FirewallPolicyRuleCollectionGroupDraftInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import reactor.core.publisher.Mono;

public final class FirewallPolicyRuleCollectionGroupDraftsClientImpl
implements FirewallPolicyRuleCollectionGroupDraftsClient {
    private final FirewallPolicyRuleCollectionGroupDraftsService service;
    private final NetworkManagementClientImpl client;

    FirewallPolicyRuleCollectionGroupDraftsClientImpl(NetworkManagementClientImpl client) {
        this.service = (FirewallPolicyRuleCollectionGroupDraftsService)RestProxy.create(FirewallPolicyRuleCollectionGroupDraftsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, "2025-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, "2025-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        return this.deleteWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        this.deleteWithResponse(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FirewallPolicyRuleCollectionGroupDraftInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupDraftInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, "2025-03-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FirewallPolicyRuleCollectionGroupDraftInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupDraftInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, "2025-03-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FirewallPolicyRuleCollectionGroupDraftInner> createOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupDraftInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((FirewallPolicyRuleCollectionGroupDraftInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FirewallPolicyRuleCollectionGroupDraftInner> createOrUpdateWithResponse(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupDraftInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FirewallPolicyRuleCollectionGroupDraftInner createOrUpdate(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, FirewallPolicyRuleCollectionGroupDraftInner parameters) {
        return (FirewallPolicyRuleCollectionGroupDraftInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FirewallPolicyRuleCollectionGroupDraftInner>> getWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, this.client.getSubscriptionId(), "2025-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FirewallPolicyRuleCollectionGroupDraftInner>> getWithResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (firewallPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null."));
        }
        if (ruleCollectionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleCollectionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, firewallPolicyName, ruleCollectionGroupName, this.client.getSubscriptionId(), "2025-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FirewallPolicyRuleCollectionGroupDraftInner> getAsync(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        return this.getWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((FirewallPolicyRuleCollectionGroupDraftInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FirewallPolicyRuleCollectionGroupDraftInner> getWithResponse(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FirewallPolicyRuleCollectionGroupDraftInner get(String resourceGroupName, String firewallPolicyName, String ruleCollectionGroupName) {
        return (FirewallPolicyRuleCollectionGroupDraftInner)((Object)this.getWithResponse(resourceGroupName, firewallPolicyName, ruleCollectionGroupName, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementClientFirewallPolicyRuleCollectionGroupDrafts")
    public static interface FirewallPolicyRuleCollectionGroupDraftsService {
        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups/{ruleCollectionGroupName}/ruleCollectionGroupDrafts/default")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="firewallPolicyName") String var3, @PathParam(value="ruleCollectionGroupName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups/{ruleCollectionGroupName}/ruleCollectionGroupDrafts/default")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FirewallPolicyRuleCollectionGroupDraftInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="firewallPolicyName") String var3, @PathParam(value="ruleCollectionGroupName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") FirewallPolicyRuleCollectionGroupDraftInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups/{ruleCollectionGroupName}/ruleCollectionGroupDrafts/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FirewallPolicyRuleCollectionGroupDraftInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="firewallPolicyName") String var3, @PathParam(value="ruleCollectionGroupName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

