/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspAccessRuleProperties;
import com.azure.resourcemanager.network.models.AccessRuleDirection;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import com.azure.resourcemanager.network.models.PerimeterBasedAccessRule;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import com.azure.resourcemanager.network.models.SubscriptionId;
import java.io.IOException;
import java.util.List;

public final class NspAccessRuleInner
extends SecurityPerimeterProxyResource {
    private NspAccessRuleProperties innerProperties;
    private SecurityPerimeterSystemData systemData;
    private String type;
    private String name;
    private String id;

    private NspAccessRuleProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public NspProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public AccessRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    public NspAccessRuleInner withDirection(AccessRuleDirection direction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withDirection(direction);
        return this;
    }

    public List<String> addressPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefixes();
    }

    public NspAccessRuleInner withAddressPrefixes(List<String> addressPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withAddressPrefixes(addressPrefixes);
        return this;
    }

    public List<String> fullyQualifiedDomainNames() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainNames();
    }

    public NspAccessRuleInner withFullyQualifiedDomainNames(List<String> fullyQualifiedDomainNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withFullyQualifiedDomainNames(fullyQualifiedDomainNames);
        return this;
    }

    public List<SubscriptionId> subscriptions() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptions();
    }

    public NspAccessRuleInner withSubscriptions(List<SubscriptionId> subscriptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withSubscriptions(subscriptions);
        return this;
    }

    public List<PerimeterBasedAccessRule> networkSecurityPerimeters() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityPerimeters();
    }

    public List<String> emailAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().emailAddresses();
    }

    public NspAccessRuleInner withEmailAddresses(List<String> emailAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withEmailAddresses(emailAddresses);
        return this;
    }

    public List<String> phoneNumbers() {
        return this.innerProperties() == null ? null : this.innerProperties().phoneNumbers();
    }

    public NspAccessRuleInner withPhoneNumbers(List<String> phoneNumbers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withPhoneNumbers(phoneNumbers);
        return this;
    }

    public List<String> serviceTags() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceTags();
    }

    public NspAccessRuleInner withServiceTags(List<String> serviceTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withServiceTags(serviceTags);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NspAccessRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (NspAccessRuleInner)((Object)jsonReader.readObject(reader -> {
            NspAccessRuleInner deserializedNspAccessRuleInner = new NspAccessRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNspAccessRuleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNspAccessRuleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNspAccessRuleInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNspAccessRuleInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNspAccessRuleInner.innerProperties = NspAccessRuleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspAccessRuleInner;
        }));
    }
}

