/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkManagerRoutingConfigurationPropertiesFormat;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteTableUsageMode;
import java.io.IOException;

public final class NetworkManagerRoutingConfigurationInner
extends ChildResource {
    private NetworkManagerRoutingConfigurationPropertiesFormat innerProperties;
    private SystemData systemData;
    private String etag;
    private String type;
    private String name;
    private String id;

    private NetworkManagerRoutingConfigurationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public NetworkManagerRoutingConfigurationInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerRoutingConfigurationPropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public RouteTableUsageMode routeTableUsageMode() {
        return this.innerProperties() == null ? null : this.innerProperties().routeTableUsageMode();
    }

    public NetworkManagerRoutingConfigurationInner withRouteTableUsageMode(RouteTableUsageMode routeTableUsageMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerRoutingConfigurationPropertiesFormat();
        }
        this.innerProperties().withRouteTableUsageMode(routeTableUsageMode);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NetworkManagerRoutingConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkManagerRoutingConfigurationInner)((Object)jsonReader.readObject(reader -> {
            NetworkManagerRoutingConfigurationInner deserializedNetworkManagerRoutingConfigurationInner = new NetworkManagerRoutingConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNetworkManagerRoutingConfigurationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNetworkManagerRoutingConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkManagerRoutingConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNetworkManagerRoutingConfigurationInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkManagerRoutingConfigurationInner.innerProperties = NetworkManagerRoutingConfigurationPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNetworkManagerRoutingConfigurationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkManagerRoutingConfigurationInner;
        }));
    }
}

