/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceTapConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.azure.resourcemanager.network.fluent.models.PrivateLinkServiceInner;
import com.azure.resourcemanager.network.models.NetworkInterfaceAuxiliaryMode;
import com.azure.resourcemanager.network.models.NetworkInterfaceAuxiliarySku;
import com.azure.resourcemanager.network.models.NetworkInterfaceDnsSettings;
import com.azure.resourcemanager.network.models.NetworkInterfaceMigrationPhase;
import com.azure.resourcemanager.network.models.NetworkInterfaceNicType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class NetworkInterfacePropertiesFormatInner
implements JsonSerializable<NetworkInterfacePropertiesFormatInner> {
    private SubResource virtualMachine;
    private NetworkSecurityGroupInner networkSecurityGroup;
    private PrivateEndpointInner privateEndpoint;
    private List<NetworkInterfaceIpConfigurationInner> ipConfigurations;
    private List<NetworkInterfaceTapConfigurationInner> tapConfigurations;
    private NetworkInterfaceDnsSettings dnsSettings;
    private String macAddress;
    private Boolean primary;
    private Boolean vnetEncryptionSupported;
    private Boolean defaultOutboundConnectivityEnabled;
    private Boolean enableAcceleratedNetworking;
    private Boolean disableTcpStateTracking;
    private Boolean enableIpForwarding;
    private List<String> hostedWorkloads;
    private SubResource dscpConfiguration;
    private String resourceGuid;
    private ProvisioningState provisioningState;
    private String workloadType;
    private NetworkInterfaceNicType nicType;
    private PrivateLinkServiceInner privateLinkService;
    private NetworkInterfaceMigrationPhase migrationPhase;
    private NetworkInterfaceAuxiliaryMode auxiliaryMode;
    private NetworkInterfaceAuxiliarySku auxiliarySku;

    public SubResource virtualMachine() {
        return this.virtualMachine;
    }

    public NetworkSecurityGroupInner networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public NetworkInterfacePropertiesFormatInner withNetworkSecurityGroup(NetworkSecurityGroupInner networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public PrivateEndpointInner privateEndpoint() {
        return this.privateEndpoint;
    }

    public List<NetworkInterfaceIpConfigurationInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    public NetworkInterfacePropertiesFormatInner withIpConfigurations(List<NetworkInterfaceIpConfigurationInner> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public List<NetworkInterfaceTapConfigurationInner> tapConfigurations() {
        return this.tapConfigurations;
    }

    public NetworkInterfaceDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public NetworkInterfacePropertiesFormatInner withDnsSettings(NetworkInterfaceDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public Boolean primary() {
        return this.primary;
    }

    public Boolean vnetEncryptionSupported() {
        return this.vnetEncryptionSupported;
    }

    public Boolean defaultOutboundConnectivityEnabled() {
        return this.defaultOutboundConnectivityEnabled;
    }

    public Boolean enableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    public NetworkInterfacePropertiesFormatInner withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    public Boolean disableTcpStateTracking() {
        return this.disableTcpStateTracking;
    }

    public NetworkInterfacePropertiesFormatInner withDisableTcpStateTracking(Boolean disableTcpStateTracking) {
        this.disableTcpStateTracking = disableTcpStateTracking;
        return this;
    }

    public Boolean enableIpForwarding() {
        return this.enableIpForwarding;
    }

    public NetworkInterfacePropertiesFormatInner withEnableIpForwarding(Boolean enableIpForwarding) {
        this.enableIpForwarding = enableIpForwarding;
        return this;
    }

    public List<String> hostedWorkloads() {
        return this.hostedWorkloads;
    }

    public SubResource dscpConfiguration() {
        return this.dscpConfiguration;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String workloadType() {
        return this.workloadType;
    }

    public NetworkInterfacePropertiesFormatInner withWorkloadType(String workloadType) {
        this.workloadType = workloadType;
        return this;
    }

    public NetworkInterfaceNicType nicType() {
        return this.nicType;
    }

    public NetworkInterfacePropertiesFormatInner withNicType(NetworkInterfaceNicType nicType) {
        this.nicType = nicType;
        return this;
    }

    public PrivateLinkServiceInner privateLinkService() {
        return this.privateLinkService;
    }

    public NetworkInterfacePropertiesFormatInner withPrivateLinkService(PrivateLinkServiceInner privateLinkService) {
        this.privateLinkService = privateLinkService;
        return this;
    }

    public NetworkInterfaceMigrationPhase migrationPhase() {
        return this.migrationPhase;
    }

    public NetworkInterfacePropertiesFormatInner withMigrationPhase(NetworkInterfaceMigrationPhase migrationPhase) {
        this.migrationPhase = migrationPhase;
        return this;
    }

    public NetworkInterfaceAuxiliaryMode auxiliaryMode() {
        return this.auxiliaryMode;
    }

    public NetworkInterfacePropertiesFormatInner withAuxiliaryMode(NetworkInterfaceAuxiliaryMode auxiliaryMode) {
        this.auxiliaryMode = auxiliaryMode;
        return this;
    }

    public NetworkInterfaceAuxiliarySku auxiliarySku() {
        return this.auxiliarySku;
    }

    public NetworkInterfacePropertiesFormatInner withAuxiliarySku(NetworkInterfaceAuxiliarySku auxiliarySku) {
        this.auxiliarySku = auxiliarySku;
        return this;
    }

    public void validate() {
        if (this.networkSecurityGroup() != null) {
            this.networkSecurityGroup().validate();
        }
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.tapConfigurations() != null) {
            this.tapConfigurations().forEach(e -> e.validate());
        }
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.privateLinkService() != null) {
            this.privateLinkService().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkSecurityGroup", (JsonSerializable)this.networkSecurityGroup);
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("dnsSettings", (JsonSerializable)this.dnsSettings);
        jsonWriter.writeBooleanField("enableAcceleratedNetworking", this.enableAcceleratedNetworking);
        jsonWriter.writeBooleanField("disableTcpStateTracking", this.disableTcpStateTracking);
        jsonWriter.writeBooleanField("enableIPForwarding", this.enableIpForwarding);
        jsonWriter.writeStringField("workloadType", this.workloadType);
        jsonWriter.writeStringField("nicType", this.nicType == null ? null : this.nicType.toString());
        jsonWriter.writeJsonField("privateLinkService", (JsonSerializable)this.privateLinkService);
        jsonWriter.writeStringField("migrationPhase", this.migrationPhase == null ? null : this.migrationPhase.toString());
        jsonWriter.writeStringField("auxiliaryMode", this.auxiliaryMode == null ? null : this.auxiliaryMode.toString());
        jsonWriter.writeStringField("auxiliarySku", this.auxiliarySku == null ? null : this.auxiliarySku.toString());
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterfacePropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterfacePropertiesFormatInner)jsonReader.readObject(reader -> {
            NetworkInterfacePropertiesFormatInner deserializedNetworkInterfacePropertiesFormatInner = new NetworkInterfacePropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualMachine".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.virtualMachine = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("networkSecurityGroup".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.networkSecurityGroup = NetworkSecurityGroupInner.fromJson(reader);
                    continue;
                }
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.privateEndpoint = PrivateEndpointInner.fromJson(reader);
                    continue;
                }
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedNetworkInterfacePropertiesFormatInner.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> NetworkInterfaceIpConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("tapConfigurations".equals(fieldName)) {
                    List tapConfigurations;
                    deserializedNetworkInterfacePropertiesFormatInner.tapConfigurations = tapConfigurations = reader.readArray(reader1 -> NetworkInterfaceTapConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("dnsSettings".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.dnsSettings = NetworkInterfaceDnsSettings.fromJson(reader);
                    continue;
                }
                if ("macAddress".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.macAddress = reader.getString();
                    continue;
                }
                if ("primary".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.primary = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("vnetEncryptionSupported".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.vnetEncryptionSupported = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultOutboundConnectivityEnabled".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.defaultOutboundConnectivityEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAcceleratedNetworking".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.enableAcceleratedNetworking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("disableTcpStateTracking".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.disableTcpStateTracking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableIPForwarding".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.enableIpForwarding = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hostedWorkloads".equals(fieldName)) {
                    List hostedWorkloads;
                    deserializedNetworkInterfacePropertiesFormatInner.hostedWorkloads = hostedWorkloads = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("dscpConfiguration".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.dscpConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("workloadType".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.workloadType = reader.getString();
                    continue;
                }
                if ("nicType".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.nicType = NetworkInterfaceNicType.fromString(reader.getString());
                    continue;
                }
                if ("privateLinkService".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.privateLinkService = PrivateLinkServiceInner.fromJson(reader);
                    continue;
                }
                if ("migrationPhase".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.migrationPhase = NetworkInterfaceMigrationPhase.fromString(reader.getString());
                    continue;
                }
                if ("auxiliaryMode".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.auxiliaryMode = NetworkInterfaceAuxiliaryMode.fromString(reader.getString());
                    continue;
                }
                if ("auxiliarySku".equals(fieldName)) {
                    deserializedNetworkInterfacePropertiesFormatInner.auxiliarySku = NetworkInterfaceAuxiliarySku.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterfacePropertiesFormatInner;
        });
    }
}

