/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.LoadDistribution;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TransportProtocol;
import java.io.IOException;
import java.util.List;

public final class LoadBalancingRulePropertiesFormat
implements JsonSerializable<LoadBalancingRulePropertiesFormat> {
    private SubResource frontendIpConfiguration;
    private SubResource backendAddressPool;
    private List<SubResource> backendAddressPools;
    private SubResource probe;
    private TransportProtocol protocol;
    private LoadDistribution loadDistribution;
    private int frontendPort;
    private Integer backendPort;
    private Integer idleTimeoutInMinutes;
    private Boolean enableFloatingIp;
    private Boolean enableTcpReset;
    private Boolean disableOutboundSnat;
    private Boolean enableConnectionTracking;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(LoadBalancingRulePropertiesFormat.class);

    public SubResource frontendIpConfiguration() {
        return this.frontendIpConfiguration;
    }

    public LoadBalancingRulePropertiesFormat withFrontendIpConfiguration(SubResource frontendIpConfiguration) {
        this.frontendIpConfiguration = frontendIpConfiguration;
        return this;
    }

    public SubResource backendAddressPool() {
        return this.backendAddressPool;
    }

    public LoadBalancingRulePropertiesFormat withBackendAddressPool(SubResource backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    public List<SubResource> backendAddressPools() {
        return this.backendAddressPools;
    }

    public LoadBalancingRulePropertiesFormat withBackendAddressPools(List<SubResource> backendAddressPools) {
        this.backendAddressPools = backendAddressPools;
        return this;
    }

    public SubResource probe() {
        return this.probe;
    }

    public LoadBalancingRulePropertiesFormat withProbe(SubResource probe) {
        this.probe = probe;
        return this;
    }

    public TransportProtocol protocol() {
        return this.protocol;
    }

    public LoadBalancingRulePropertiesFormat withProtocol(TransportProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public LoadDistribution loadDistribution() {
        return this.loadDistribution;
    }

    public LoadBalancingRulePropertiesFormat withLoadDistribution(LoadDistribution loadDistribution) {
        this.loadDistribution = loadDistribution;
        return this;
    }

    public int frontendPort() {
        return this.frontendPort;
    }

    public LoadBalancingRulePropertiesFormat withFrontendPort(int frontendPort) {
        this.frontendPort = frontendPort;
        return this;
    }

    public Integer backendPort() {
        return this.backendPort;
    }

    public LoadBalancingRulePropertiesFormat withBackendPort(Integer backendPort) {
        this.backendPort = backendPort;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public LoadBalancingRulePropertiesFormat withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public Boolean enableFloatingIp() {
        return this.enableFloatingIp;
    }

    public LoadBalancingRulePropertiesFormat withEnableFloatingIp(Boolean enableFloatingIp) {
        this.enableFloatingIp = enableFloatingIp;
        return this;
    }

    public Boolean enableTcpReset() {
        return this.enableTcpReset;
    }

    public LoadBalancingRulePropertiesFormat withEnableTcpReset(Boolean enableTcpReset) {
        this.enableTcpReset = enableTcpReset;
        return this;
    }

    public Boolean disableOutboundSnat() {
        return this.disableOutboundSnat;
    }

    public LoadBalancingRulePropertiesFormat withDisableOutboundSnat(Boolean disableOutboundSnat) {
        this.disableOutboundSnat = disableOutboundSnat;
        return this;
    }

    public Boolean enableConnectionTracking() {
        return this.enableConnectionTracking;
    }

    public LoadBalancingRulePropertiesFormat withEnableConnectionTracking(Boolean enableConnectionTracking) {
        this.enableConnectionTracking = enableConnectionTracking;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model LoadBalancingRulePropertiesFormat"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeIntField("frontendPort", this.frontendPort);
        jsonWriter.writeJsonField("frontendIPConfiguration", (JsonSerializable)this.frontendIpConfiguration);
        jsonWriter.writeJsonField("backendAddressPool", (JsonSerializable)this.backendAddressPool);
        jsonWriter.writeArrayField("backendAddressPools", this.backendAddressPools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("probe", (JsonSerializable)this.probe);
        jsonWriter.writeStringField("loadDistribution", this.loadDistribution == null ? null : this.loadDistribution.toString());
        jsonWriter.writeNumberField("backendPort", (Number)this.backendPort);
        jsonWriter.writeNumberField("idleTimeoutInMinutes", (Number)this.idleTimeoutInMinutes);
        jsonWriter.writeBooleanField("enableFloatingIP", this.enableFloatingIp);
        jsonWriter.writeBooleanField("enableTcpReset", this.enableTcpReset);
        jsonWriter.writeBooleanField("disableOutboundSnat", this.disableOutboundSnat);
        jsonWriter.writeBooleanField("enableConnectionTracking", this.enableConnectionTracking);
        return jsonWriter.writeEndObject();
    }

    public static LoadBalancingRulePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (LoadBalancingRulePropertiesFormat)jsonReader.readObject(reader -> {
            LoadBalancingRulePropertiesFormat deserializedLoadBalancingRulePropertiesFormat = new LoadBalancingRulePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocol".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.protocol = TransportProtocol.fromString(reader.getString());
                    continue;
                }
                if ("frontendPort".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.frontendPort = reader.getInt();
                    continue;
                }
                if ("frontendIPConfiguration".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.frontendIpConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("backendAddressPool".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.backendAddressPool = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("backendAddressPools".equals(fieldName)) {
                    List backendAddressPools;
                    deserializedLoadBalancingRulePropertiesFormat.backendAddressPools = backendAddressPools = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("probe".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.probe = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("loadDistribution".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.loadDistribution = LoadDistribution.fromString(reader.getString());
                    continue;
                }
                if ("backendPort".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.backendPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.idleTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enableFloatingIP".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.enableFloatingIp = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableTcpReset".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.enableTcpReset = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("disableOutboundSnat".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.disableOutboundSnat = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableConnectionTracking".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.enableConnectionTracking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedLoadBalancingRulePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoadBalancingRulePropertiesFormat;
        });
    }
}

