/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.FlowLogPropertiesFormat;
import com.azure.resourcemanager.network.models.FlowLogFormatParameters;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import com.azure.resourcemanager.network.models.TrafficAnalyticsProperties;
import java.io.IOException;
import java.util.Map;

public final class FlowLogInner
extends Resource {
    private FlowLogPropertiesFormat innerProperties;
    private String etag;
    private ManagedServiceIdentity identity;
    private String id;
    private String type;
    private String name;

    private FlowLogPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public FlowLogInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String id() {
        return this.id;
    }

    public FlowLogInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public FlowLogInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public FlowLogInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String targetResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceId();
    }

    public FlowLogInner withTargetResourceId(String targetResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withTargetResourceId(targetResourceId);
        return this;
    }

    public String targetResourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceGuid();
    }

    public String storageId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageId();
    }

    public FlowLogInner withStorageId(String storageId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withStorageId(storageId);
        return this;
    }

    public String enabledFilteringCriteria() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledFilteringCriteria();
    }

    public FlowLogInner withEnabledFilteringCriteria(String enabledFilteringCriteria) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withEnabledFilteringCriteria(enabledFilteringCriteria);
        return this;
    }

    public String recordTypes() {
        return this.innerProperties() == null ? null : this.innerProperties().recordTypes();
    }

    public FlowLogInner withRecordTypes(String recordTypes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withRecordTypes(recordTypes);
        return this;
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public FlowLogInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public RetentionPolicyParameters retentionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionPolicy();
    }

    public FlowLogInner withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withRetentionPolicy(retentionPolicy);
        return this;
    }

    public FlowLogFormatParameters format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    public FlowLogInner withFormat(FlowLogFormatParameters format) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withFormat(format);
        return this;
    }

    public TrafficAnalyticsProperties flowAnalyticsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().flowAnalyticsConfiguration();
    }

    public FlowLogInner withFlowAnalyticsConfiguration(TrafficAnalyticsProperties flowAnalyticsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withFlowAnalyticsConfiguration(flowAnalyticsConfiguration);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static FlowLogInner fromJson(JsonReader jsonReader) throws IOException {
        return (FlowLogInner)((Object)jsonReader.readObject(reader -> {
            FlowLogInner deserializedFlowLogInner = new FlowLogInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedFlowLogInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFlowLogInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedFlowLogInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedFlowLogInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFlowLogInner.innerProperties = FlowLogPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedFlowLogInner.etag = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedFlowLogInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedFlowLogInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlowLogInner;
        }));
    }
}

