// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * List of properties of a link provider.
 */
@Fluent
public final class VpnLinkProviderProperties implements JsonSerializable<VpnLinkProviderProperties> {
    /*
     * Name of the link provider.
     */
    private String linkProviderName;

    /*
     * Link speed.
     */
    private Integer linkSpeedInMbps;

    /**
     * Creates an instance of VpnLinkProviderProperties class.
     */
    public VpnLinkProviderProperties() {
    }

    /**
     * Get the linkProviderName property: Name of the link provider.
     * 
     * @return the linkProviderName value.
     */
    public String linkProviderName() {
        return this.linkProviderName;
    }

    /**
     * Set the linkProviderName property: Name of the link provider.
     * 
     * @param linkProviderName the linkProviderName value to set.
     * @return the VpnLinkProviderProperties object itself.
     */
    public VpnLinkProviderProperties withLinkProviderName(String linkProviderName) {
        this.linkProviderName = linkProviderName;
        return this;
    }

    /**
     * Get the linkSpeedInMbps property: Link speed.
     * 
     * @return the linkSpeedInMbps value.
     */
    public Integer linkSpeedInMbps() {
        return this.linkSpeedInMbps;
    }

    /**
     * Set the linkSpeedInMbps property: Link speed.
     * 
     * @param linkSpeedInMbps the linkSpeedInMbps value to set.
     * @return the VpnLinkProviderProperties object itself.
     */
    public VpnLinkProviderProperties withLinkSpeedInMbps(Integer linkSpeedInMbps) {
        this.linkSpeedInMbps = linkSpeedInMbps;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("linkProviderName", this.linkProviderName);
        jsonWriter.writeNumberField("linkSpeedInMbps", this.linkSpeedInMbps);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnLinkProviderProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnLinkProviderProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnLinkProviderProperties.
     */
    public static VpnLinkProviderProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnLinkProviderProperties deserializedVpnLinkProviderProperties = new VpnLinkProviderProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("linkProviderName".equals(fieldName)) {
                    deserializedVpnLinkProviderProperties.linkProviderName = reader.getString();
                } else if ("linkSpeedInMbps".equals(fieldName)) {
                    deserializedVpnLinkProviderProperties.linkSpeedInMbps = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnLinkProviderProperties;
        });
    }
}
